/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.Principal;
import java.time.Duration;
import java.time.Instant;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.MultiFactorAuthenticationTransition;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.MultiFactorAuthenticationContext;
import net.shibboleth.idp.authn.impl.DefaultAuthenticationResultSerializer;
import net.shibboleth.idp.authn.impl.PopulateMultiFactorAuthenticationContext;
import net.shibboleth.idp.authn.principal.AuthenticationResultPrincipal;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.FunctionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageSerializer;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PopulateMultiFactorAuthenticationContextTest {
    private RequestContext rc;
    private ProfileRequestContext prc;
    private AuthenticationContext ac;
    private PopulateMultiFactorAuthenticationContext action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.rc = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.rc);
        AuthenticationContext authCtx = this.ac = (AuthenticationContext)this.prc.ensureSubcontext(AuthenticationContext.class);
        AuthenticationFlowDescriptor flow = new AuthenticationFlowDescriptor();
        authCtx.setAttemptedFlow(flow);
        flow.setId("authn/MFA");
        flow.setResultSerializer((StorageSerializer)new DefaultAuthenticationResultSerializer());
        flow.initialize();
        this.action = new PopulateMultiFactorAuthenticationContext();
    }

    @Test
    public void testEmpty() throws ComponentInitializationException {
        this.action.initialize();
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertEvent((Event)event, (String)"ReselectFlow");
        MultiFactorAuthenticationContext mfa = (MultiFactorAuthenticationContext)this.ac.getSubcontext(MultiFactorAuthenticationContext.class);
        Assert.assertNull((Object)mfa);
    }

    @Test
    public void testTransitions() throws ComponentInitializationException {
        this.action.setTransitionMapLookupStrategy(FunctionSupport.constant((Object)CollectionSupport.singletonMap((Object)"", (Object)new MultiFactorAuthenticationTransition())));
        this.action.initialize();
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        MultiFactorAuthenticationContext mfa = (MultiFactorAuthenticationContext)this.ac.getSubcontext(MultiFactorAuthenticationContext.class);
        assert (mfa != null);
        Assert.assertEquals((Object)this.ac.getAttemptedFlow(), (Object)mfa.getAuthenticationFlowDescriptor());
        Assert.assertEquals((int)mfa.getTransitionMap().size(), (int)1);
        Assert.assertNotNull(mfa.getTransitionMap().get(null));
        Assert.assertTrue((boolean)mfa.getActiveResults().isEmpty());
    }

    @Test
    public void testResults() throws ComponentInitializationException {
        Subject subject = new Subject();
        AuthenticationResult result = new AuthenticationResult("foo", new Subject());
        result.setAuthenticationInstant(Instant.now().minusSeconds(7200L));
        subject.getPrincipals().add((Principal)new AuthenticationResultPrincipal(result));
        result = new AuthenticationResult("bar", new Subject());
        subject.getPrincipals().add((Principal)new AuthenticationResultPrincipal(result));
        result = new AuthenticationResult("baz", new Subject());
        subject.getPrincipals().add((Principal)new AuthenticationResultPrincipal(result));
        result = new AuthenticationResult("bav", new Subject());
        result.setAuthenticationInstant(Instant.now().minusSeconds(1000L));
        subject.getPrincipals().add((Principal)new AuthenticationResultPrincipal(result));
        result = new AuthenticationResult("bag", new Subject());
        result.setAuthenticationInstant(Instant.now().minusSeconds(2000L));
        subject.getPrincipals().add((Principal)new AuthenticationResultPrincipal(result));
        this.ac.getActiveResults().put("authn/MFA", new AuthenticationResult("authn/MFA", subject));
        AuthenticationFlowDescriptor desc = new AuthenticationFlowDescriptor();
        desc.setId("foo");
        desc.setResultSerializer((StorageSerializer)new DefaultAuthenticationResultSerializer());
        desc.setLifetime(Duration.ofHours(1L));
        desc.initialize();
        this.ac.getAvailableFlows().put(desc.getId(), desc);
        desc = new AuthenticationFlowDescriptor();
        desc.setId("bar");
        desc.setResultSerializer((StorageSerializer)new DefaultAuthenticationResultSerializer());
        desc.setLifetime(Duration.ofHours(1L));
        desc.initialize();
        this.ac.getAvailableFlows().put(desc.getId(), desc);
        desc = new AuthenticationFlowDescriptor();
        desc.setId("bav");
        desc.setResultSerializer((StorageSerializer)new DefaultAuthenticationResultSerializer());
        desc.setLifetime(Duration.ofHours(1L));
        desc.initialize();
        this.ac.getAvailableFlows().put(desc.getId(), desc);
        desc = new AuthenticationFlowDescriptor();
        desc.setId("bag");
        desc.setResultSerializer((StorageSerializer)new DefaultAuthenticationResultSerializer());
        desc.setLifetime(Duration.ofHours(1L));
        desc.initialize();
        this.ac.getAvailableFlows().put(desc.getId(), desc);
        this.ac.setMaxAge(Duration.ofMinutes(30L));
        this.action.setTransitionMapLookupStrategy(FunctionSupport.constant((Object)CollectionSupport.singletonMap((Object)"", (Object)new MultiFactorAuthenticationTransition())));
        this.action.initialize();
        Event event = this.action.execute(this.rc);
        ActionTestingSupport.assertProceedEvent((Event)event);
        MultiFactorAuthenticationContext mfa = (MultiFactorAuthenticationContext)this.ac.getSubcontext(MultiFactorAuthenticationContext.class);
        assert (mfa != null);
        Assert.assertEquals((Object)this.ac.getAttemptedFlow(), (Object)mfa.getAuthenticationFlowDescriptor());
        Assert.assertEquals((int)mfa.getActiveResults().size(), (int)2);
        Assert.assertNull(mfa.getActiveResults().get("foo"));
        Assert.assertNotNull(mfa.getActiveResults().get("bar"));
        Assert.assertNull(mfa.getActiveResults().get("baz"));
        Assert.assertNotNull(mfa.getActiveResults().get("bav"));
        Assert.assertNull(mfa.getActiveResults().get("bag"));
    }
}

