/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.List;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.SubjectCanonicalizationFlowDescriptor;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.impl.PopulateSubjectCanonicalizationContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PopulateSubjectCanonicalizationContextTest {
    protected List<SubjectCanonicalizationFlowDescriptor> c14nFlows;
    protected RequestContext src;
    protected ProfileRequestContext prc;

    @BeforeMethod
    public void setUp() throws Exception {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        ((SubjectCanonicalizationContext)this.prc.ensureSubcontext(SubjectCanonicalizationContext.class)).setSubject(new Subject());
        this.c14nFlows = List.of(new SubjectCanonicalizationFlowDescriptor(), new SubjectCanonicalizationFlowDescriptor(), new SubjectCanonicalizationFlowDescriptor());
        this.c14nFlows.get(0).setId("test1");
        this.c14nFlows.get(1).setId("test2");
        this.c14nFlows.get(2).setId("test3");
        PopulateSubjectCanonicalizationContext action = new PopulateSubjectCanonicalizationContext();
        action.setAvailableFlows(this.c14nFlows);
        action.initialize();
        action.execute(this.src);
    }

    @Test
    public void testAction() throws Exception {
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        SubjectCanonicalizationContext c14nCtx = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        assert (c14nCtx != null);
        Assert.assertEquals((int)c14nCtx.getPotentialFlows().size(), (int)3);
        Assert.assertNotNull(c14nCtx.getPotentialFlows().get("test1"));
    }
}

