/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.Arrays;
import java.util.Map;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.impl.PreserveAuthenticationFlowState;
import net.shibboleth.idp.authn.impl.testing.BaseAuthenticationContextTest;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.testing.ConstantSupplier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PreserveAuthenticationFlowStateTest
extends BaseAuthenticationContextTest {
    private PreserveAuthenticationFlowState action;

    @Override
    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        this.action = new PreserveAuthenticationFlowState();
        MockHttpServletRequest request = new MockHttpServletRequest();
        this.action.setHttpServletRequestSupplier((NonnullSupplier)new ConstantSupplier((Object)request));
        this.action.setParameterNames(Arrays.asList("foo", "foo2"));
        this.action.initialize();
    }

    @Test
    public void testNoServlet() throws ComponentInitializationException {
        this.action = new PreserveAuthenticationFlowState();
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        Map asm = ac.getAuthenticationStateMap();
        Assert.assertTrue((boolean)asm.isEmpty());
    }

    @Test
    public void testNoParameters() throws ComponentInitializationException {
        this.action = new PreserveAuthenticationFlowState();
        MockHttpServletRequest request = new MockHttpServletRequest();
        this.action.setHttpServletRequestSupplier((NonnullSupplier)new ConstantSupplier((Object)request));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        Map asm = ac.getAuthenticationStateMap();
        Assert.assertTrue((boolean)asm.isEmpty());
    }

    @Test
    public void testNoneFound() {
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        Map asm = ac.getAuthenticationStateMap();
        Assert.assertTrue((boolean)asm.isEmpty());
    }

    @Test
    public void testNoValues() {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("foo", (String)null);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        Assert.assertEquals((int)authCtx.getAuthenticationStateMap().size(), (int)1);
        Assert.assertTrue((boolean)authCtx.getAuthenticationStateMap().containsKey("foo"));
        Assert.assertNull(authCtx.getAuthenticationStateMap().get("foo"));
    }

    @Test
    public void testSingleValued() {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("foo", "bar");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("foo2", "bar2");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        Assert.assertEquals((int)authCtx.getAuthenticationStateMap().size(), (int)2);
        Assert.assertEquals(authCtx.getAuthenticationStateMap().get("foo"), (Object)"bar");
        Assert.assertEquals(authCtx.getAuthenticationStateMap().get("foo2"), (Object)"bar2");
    }

    @Test
    public void testMultiValued() {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("foo", new String[]{"bar", "bar2"});
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        Assert.assertEquals((int)authCtx.getAuthenticationStateMap().size(), (int)1);
        Assert.assertEquals(authCtx.getAuthenticationStateMap().get("foo"), Arrays.asList("bar", "bar2"));
    }
}

