/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.shibboleth.idp.authn.impl.RelyingPartyMapJAASLoginConfigStrategy;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.ConstraintViolationException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RelyingPartyMapJAASLoginConfigStrategyTest {
    private static final String DEFAULT_JAAS_CONFIG = "ShibUserPassAuth";
    private RelyingPartyMapJAASLoginConfigStrategy strategy;
    private ProfileRequestContext profileRequestContext;
    private RelyingPartyContext relyingPartyContext;
    private String entityID = "https://www.example.org/saml";
    private HashMap<String, String> rpMap;
    private Object nullObj;

    @BeforeMethod
    public void setUp() {
        this.profileRequestContext = new ProfileRequestContext();
        this.relyingPartyContext = (RelyingPartyContext)this.profileRequestContext.ensureSubcontext(RelyingPartyContext.class);
        this.relyingPartyContext.setRelyingPartyId(this.entityID);
        this.rpMap = new HashMap();
        this.rpMap.put(this.entityID, "  MyJAAS   ");
    }

    @Test
    public void testNoRelyingPartyContext() {
        this.profileRequestContext.removeSubcontext(RelyingPartyContext.class);
        assert (this.rpMap != null);
        this.strategy = new RelyingPartyMapJAASLoginConfigStrategy(this.rpMap);
        Collection result = this.strategy.apply(this.profileRequestContext);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)1);
        Pair resultPair = (Pair)result.iterator().next();
        Assert.assertNull((Object)resultPair.getSecond());
        Assert.assertEquals((String)((String)resultPair.getFirst()), (String)DEFAULT_JAAS_CONFIG);
    }

    @Test
    public void testNoRelyingPartyId() {
        this.relyingPartyContext.setRelyingPartyId(null);
        assert (this.rpMap != null);
        this.strategy = new RelyingPartyMapJAASLoginConfigStrategy(this.rpMap);
        Collection result = this.strategy.apply(this.profileRequestContext);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)1);
        Pair resultPair = (Pair)result.iterator().next();
        Assert.assertNull((Object)resultPair.getSecond());
        Assert.assertEquals((String)((String)resultPair.getFirst()), (String)DEFAULT_JAAS_CONFIG);
    }

    @Test
    public void testNoMappingFound() {
        this.relyingPartyContext.setRelyingPartyId("SomeOtherRP");
        assert (this.rpMap != null);
        this.strategy = new RelyingPartyMapJAASLoginConfigStrategy(this.rpMap);
        Collection result = this.strategy.apply(this.profileRequestContext);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)1);
        Pair resultPair = (Pair)result.iterator().next();
        Assert.assertNull((Object)resultPair.getSecond());
        Assert.assertEquals((String)((String)resultPair.getFirst()), (String)DEFAULT_JAAS_CONFIG);
    }

    @Test
    public void testMappingFound() {
        assert (this.rpMap != null);
        this.strategy = new RelyingPartyMapJAASLoginConfigStrategy(this.rpMap);
        Collection result = this.strategy.apply(this.profileRequestContext);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((int)result.size(), (int)1);
        Pair resultPair = (Pair)result.iterator().next();
        Assert.assertNull((Object)resultPair.getSecond());
        Assert.assertEquals((String)((String)resultPair.getFirst()), (String)"MyJAAS");
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullInputMap() {
        this.strategy = new RelyingPartyMapJAASLoginConfigStrategy((Map)this.nullObj);
    }
}

