/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.Principal;
import java.util.Collection;
import java.util.List;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.PreferredPrincipalContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.impl.SelectAuthenticationFlow;
import net.shibboleth.idp.authn.impl.testing.BaseAuthenticationContextTest;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactory;
import net.shibboleth.idp.authn.principal.impl.ExactPrincipalEvalPredicateFactory;
import net.shibboleth.idp.authn.testing.TestPrincipal;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.opensaml.messaging.context.BaseContext;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SelectAuthenticationFlowTest
extends BaseAuthenticationContextTest {
    private SelectAuthenticationFlow action;

    @Override
    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        this.action = new SelectAuthenticationFlow();
        this.action.initialize();
    }

    @Test
    public void testNoRequestNoneActive() {
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"test1");
        Assert.assertNull((Object)authCtx.getAuthenticationResult());
        AuthenticationFlowDescriptor attemptedFlow = authCtx.getAttemptedFlow();
        assert (attemptedFlow != null && event != null);
        Assert.assertEquals((Object)attemptedFlow, authCtx.getPotentialFlows().get(event.getId()));
        Assert.assertEquals((String)attemptedFlow.getId(), (String)"test1");
    }

    @Test
    public void testNoRequestNoneActivePassive() {
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        authCtx.setIsPassive(true);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"test2");
        Assert.assertNull((Object)authCtx.getAuthenticationResult());
        AuthenticationFlowDescriptor attemptedFlow = authCtx.getAttemptedFlow();
        assert (attemptedFlow != null && event != null);
        Assert.assertEquals((Object)attemptedFlow, authCtx.getPotentialFlows().get(event.getId()));
        Assert.assertEquals((String)attemptedFlow.getId(), (String)"test2");
    }

    @Test
    public void testNoRequestNoneActiveIntermediate() {
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        authCtx.getIntermediateFlows().put("test1", (AuthenticationFlowDescriptor)authCtx.getPotentialFlows().get("test1"));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"test2");
        Assert.assertNull((Object)authCtx.getAuthenticationResult());
        AuthenticationFlowDescriptor attemptedFlow = authCtx.getAttemptedFlow();
        assert (attemptedFlow != null && event != null);
        Assert.assertEquals((Object)attemptedFlow, authCtx.getPotentialFlows().get(event.getId()));
        Assert.assertEquals((String)attemptedFlow.getId(), (String)"test2");
    }

    @Test
    public void testNoRequestActive() {
        AuthenticationResult active = new AuthenticationResult("test2", new Subject());
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        authCtx.setActiveResults((Iterable)CollectionSupport.singletonList((Object)active));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((Object)active, (Object)authCtx.getAuthenticationResult());
    }

    @Test
    public void testNoRequestForced() {
        AuthenticationResult active = new AuthenticationResult("test2", new Subject());
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        authCtx.setActiveResults((Iterable)CollectionSupport.singletonList((Object)active));
        authCtx.setForceAuthn(true);
        Event event = this.action.execute(this.src);
        assert (event != null);
        Assert.assertNull((Object)authCtx.getAuthenticationResult());
        Assert.assertEquals((Object)authCtx.getAttemptedFlow(), authCtx.getPotentialFlows().get(event.getId()));
    }

    @Test
    public void testRequestNoMatch() {
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        RequestedPrincipalContext rpc = new RequestedPrincipalContext();
        rpc.setOperator("exact");
        rpc.setRequestedPrincipals(CollectionSupport.singletonList((Object)new TestPrincipal("foo")));
        assert (authCtx != null);
        authCtx.addSubcontext((BaseContext)rpc, true);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"RequestUnsupported");
    }

    @Test
    public void testPreferredNoMatch() {
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        List principals = CollectionSupport.singletonList((Object)new TestPrincipal("test3"));
        PreferredPrincipalContext ppc = new PreferredPrincipalContext();
        ppc.setPreferredPrincipals(principals);
        assert (authCtx != null);
        authCtx.addSubcontext((BaseContext)ppc, true);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"test3");
        Assert.assertNull((Object)authCtx.getAuthenticationResult());
        AuthenticationFlowDescriptor attemptedFlow = authCtx.getAttemptedFlow();
        assert (attemptedFlow != null && event != null);
        Assert.assertEquals((String)attemptedFlow.getId(), (String)"test3");
    }

    @Test
    public void testPreferredNoneActive() {
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        List principals = CollectionSupport.singletonList((Object)new TestPrincipal("test3"));
        PreferredPrincipalContext ppc = new PreferredPrincipalContext();
        ppc.setPreferredPrincipals(principals);
        assert (authCtx != null);
        authCtx.addSubcontext((BaseContext)ppc, true);
        ((AuthenticationFlowDescriptor)authCtx.getPotentialFlows().get("test3")).setSupportedPrincipals((Collection)principals);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"test3");
        Assert.assertNull((Object)authCtx.getAuthenticationResult());
        AuthenticationFlowDescriptor attemptedFlow = authCtx.getAttemptedFlow();
        assert (attemptedFlow != null);
        Assert.assertEquals((String)attemptedFlow.getId(), (String)"test3");
    }

    @Test
    public void testPreferredPickActiveNonMatch() {
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        List principals = CollectionSupport.listOf((Object)new TestPrincipal("test3"), (Object)new TestPrincipal("test2"));
        PreferredPrincipalContext ppc = new PreferredPrincipalContext();
        ppc.setPreferredPrincipals(principals);
        assert (authCtx != null);
        authCtx.addSubcontext((BaseContext)ppc, true);
        AuthenticationResult active = new AuthenticationResult("test1", new Subject());
        active.getSubject().getPrincipals().add((Principal)new TestPrincipal("test1"));
        authCtx.setActiveResults((Iterable)CollectionSupport.singletonList((Object)active));
        ((AuthenticationFlowDescriptor)authCtx.getPotentialFlows().get("test3")).setSupportedPrincipals((Collection)CollectionSupport.singletonList((Object)((Principal)principals.get(0))));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((Object)active, (Object)authCtx.getAuthenticationResult());
    }

    @Test
    public void testPreferredPickActiveMatch() {
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        List principals = CollectionSupport.listOf((Object)new TestPrincipal("test3"), (Object)new TestPrincipal("test2"));
        PreferredPrincipalContext ppc = new PreferredPrincipalContext();
        ppc.setPreferredPrincipals(principals);
        assert (authCtx != null);
        authCtx.addSubcontext((BaseContext)ppc, true);
        AuthenticationResult active1 = new AuthenticationResult("test1", new Subject());
        AuthenticationResult active3 = new AuthenticationResult("test3", new Subject());
        active1.getSubject().getPrincipals().add((Principal)new TestPrincipal("test1"));
        active3.getSubject().getPrincipals().add((Principal)new TestPrincipal("test3"));
        authCtx.setActiveResults((Iterable)CollectionSupport.listOf((Object)active1, (Object)active3));
        ((AuthenticationFlowDescriptor)authCtx.getPotentialFlows().get("test3")).setSupportedPrincipals((Collection)CollectionSupport.singletonList((Object)((Principal)principals.get(0))));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((Object)active3, (Object)authCtx.getAuthenticationResult());
    }

    @Test
    public void testRequestNoneActive() {
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        List principals = CollectionSupport.singletonList((Object)new TestPrincipal("test3"));
        RequestedPrincipalContext rpc = new RequestedPrincipalContext();
        rpc.getPrincipalEvalPredicateFactoryRegistry().register(TestPrincipal.class, "exact", (PrincipalEvalPredicateFactory)new ExactPrincipalEvalPredicateFactory());
        rpc.setOperator("exact");
        rpc.setRequestedPrincipals(principals);
        assert (authCtx != null);
        authCtx.addSubcontext((BaseContext)rpc, true);
        ((AuthenticationFlowDescriptor)authCtx.getPotentialFlows().get("test3")).setSupportedPrincipals((Collection)principals);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"test3");
        Assert.assertNull((Object)authCtx.getAuthenticationResult());
        AuthenticationFlowDescriptor attemptedFlow = authCtx.getAttemptedFlow();
        assert (attemptedFlow != null);
        Assert.assertEquals((String)attemptedFlow.getId(), (String)"test3");
    }

    @Test
    public void testRequestNoneActiveIntermediate() {
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        authCtx.getIntermediateFlows().put("test2", (AuthenticationFlowDescriptor)authCtx.getPotentialFlows().get("test2"));
        List principals = CollectionSupport.listOf((Object)new TestPrincipal("test3"), (Object)new TestPrincipal("test2"));
        RequestedPrincipalContext rpc = new RequestedPrincipalContext();
        rpc.getPrincipalEvalPredicateFactoryRegistry().register(TestPrincipal.class, "exact", (PrincipalEvalPredicateFactory)new ExactPrincipalEvalPredicateFactory());
        rpc.setOperator("exact");
        rpc.setRequestedPrincipals(principals);
        authCtx.addSubcontext((BaseContext)rpc, true);
        ((AuthenticationFlowDescriptor)authCtx.getPotentialFlows().get("test2")).setSupportedPrincipals((Collection)principals);
        ((AuthenticationFlowDescriptor)authCtx.getPotentialFlows().get("test3")).setSupportedPrincipals((Collection)principals);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"test3");
        Assert.assertNull((Object)authCtx.getAuthenticationResult());
        AuthenticationFlowDescriptor flow = authCtx.getAttemptedFlow();
        assert (flow != null);
        Assert.assertEquals((String)flow.getId(), (String)"test3");
    }

    @Test
    public void testRequestPickInactive() {
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        List principals = CollectionSupport.listOf((Object)new TestPrincipal("test3"), (Object)new TestPrincipal("test2"));
        RequestedPrincipalContext rpc = new RequestedPrincipalContext();
        rpc.getPrincipalEvalPredicateFactoryRegistry().register(TestPrincipal.class, "exact", (PrincipalEvalPredicateFactory)new ExactPrincipalEvalPredicateFactory());
        rpc.setOperator("exact");
        rpc.setRequestedPrincipals(principals);
        assert (authCtx != null);
        authCtx.addSubcontext((BaseContext)rpc, true);
        AuthenticationResult active = new AuthenticationResult("test2", new Subject());
        active.getSubject().getPrincipals().add((Principal)new TestPrincipal("test2"));
        authCtx.setActiveResults((Iterable)CollectionSupport.singletonList((Object)active));
        ((AuthenticationFlowDescriptor)authCtx.getPotentialFlows().get("test3")).setSupportedPrincipals((Collection)CollectionSupport.singletonList((Object)((Principal)principals.get(0))));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"test3");
        Assert.assertNull((Object)authCtx.getAuthenticationResult());
        Assert.assertEquals((Object)authCtx.getAttemptedFlow(), authCtx.getPotentialFlows().get("test3"));
    }

    @Test
    public void testRequestPickActive() {
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        List principals = CollectionSupport.listOf((Object)new TestPrincipal("test3"), (Object)new TestPrincipal("test2"));
        RequestedPrincipalContext rpc = new RequestedPrincipalContext();
        rpc.getPrincipalEvalPredicateFactoryRegistry().register(TestPrincipal.class, "exact", (PrincipalEvalPredicateFactory)new ExactPrincipalEvalPredicateFactory());
        rpc.setOperator("exact");
        rpc.setRequestedPrincipals(principals);
        assert (authCtx != null);
        authCtx.addSubcontext((BaseContext)rpc, true);
        AuthenticationResult active = new AuthenticationResult("test3", new Subject());
        active.getSubject().getPrincipals().add((Principal)new TestPrincipal("test3"));
        authCtx.setActiveResults((Iterable)CollectionSupport.singletonList((Object)active));
        ((AuthenticationFlowDescriptor)authCtx.getPotentialFlows().get("test3")).setSupportedPrincipals((Collection)CollectionSupport.singletonList((Object)((Principal)principals.get(0))));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((Object)active, (Object)authCtx.getAuthenticationResult());
    }

    @Test
    public void testRequestFavorSSO() throws ComponentInitializationException {
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        List principals = CollectionSupport.listOf((Object)new TestPrincipal("test3"), (Object)new TestPrincipal("test2"));
        RequestedPrincipalContext rpc = new RequestedPrincipalContext();
        rpc.getPrincipalEvalPredicateFactoryRegistry().register(TestPrincipal.class, "exact", (PrincipalEvalPredicateFactory)new ExactPrincipalEvalPredicateFactory());
        rpc.setOperator("exact");
        rpc.setRequestedPrincipals(principals);
        authCtx.addSubcontext((BaseContext)rpc, true);
        AuthenticationResult active = new AuthenticationResult("test2", new Subject());
        active.getSubject().getPrincipals().add((Principal)new TestPrincipal("test2"));
        authCtx.setActiveResults((Iterable)CollectionSupport.singletonList((Object)active));
        ((AuthenticationFlowDescriptor)authCtx.getPotentialFlows().get("test3")).setSupportedPrincipals((Collection)CollectionSupport.singletonList((Object)((Principal)principals.get(0))));
        this.action = new SelectAuthenticationFlow();
        this.action.setFavorSSO(true);
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((Object)active, (Object)authCtx.getAuthenticationResult());
    }
}

