/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import net.shibboleth.idp.authn.SubjectCanonicalizationFlowDescriptor;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.impl.PopulateSubjectCanonicalizationContextTest;
import net.shibboleth.idp.authn.impl.SelectSubjectCanonicalizationFlow;
import net.shibboleth.shared.logic.PredicateSupport;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SelectSubjectCanonicalizationFlowTest
extends PopulateSubjectCanonicalizationContextTest {
    private SelectSubjectCanonicalizationFlow action;
    private SubjectCanonicalizationContext c14nCtx;

    @Override
    @BeforeMethod
    public void setUp() throws Exception {
        super.setUp();
        this.action = new SelectSubjectCanonicalizationFlow();
        this.action.initialize();
        this.c14nCtx = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
    }

    @Test
    public void testSelect() {
        Event event = this.action.execute(this.src);
        assert (event != null);
        SubjectCanonicalizationFlowDescriptor flow = this.c14nCtx.getAttemptedFlow();
        assert (flow != null);
        Assert.assertEquals((Object)this.c14nCtx.getAttemptedFlow(), this.c14nCtx.getPotentialFlows().get(event.getId()));
        Assert.assertEquals((String)flow.getId(), (String)"test1");
    }

    @Test
    public void testIntermediate() {
        this.c14nCtx.getIntermediateFlows().put("test1", (SubjectCanonicalizationFlowDescriptor)this.c14nCtx.getPotentialFlows().get("test1"));
        Event event = this.action.execute(this.src);
        SubjectCanonicalizationFlowDescriptor flow = this.c14nCtx.getAttemptedFlow();
        assert (flow != null && event != null);
        Assert.assertEquals((Object)this.c14nCtx.getAttemptedFlow(), this.c14nCtx.getPotentialFlows().get(event.getId()));
        Assert.assertEquals((String)flow.getId(), (String)"test2");
    }

    @Test
    public void testPredicate() {
        ((SubjectCanonicalizationFlowDescriptor)this.c14nCtx.getPotentialFlows().get("test1")).setActivationCondition(PredicateSupport.alwaysFalse());
        Event event = this.action.execute(this.src);
        SubjectCanonicalizationFlowDescriptor flow = this.c14nCtx.getAttemptedFlow();
        assert (flow != null && event != null);
        Assert.assertEquals((Object)this.c14nCtx.getAttemptedFlow(), this.c14nCtx.getPotentialFlows().get(event.getId()));
        Assert.assertEquals((String)flow.getId(), (String)"test2");
    }
}

