/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.Principal;
import java.util.Arrays;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.impl.SimpleSubjectCanonicalization;
import net.shibboleth.idp.authn.impl.testing.BaseAuthenticationContextTest;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SimpleSubjectCanonicalizationTest
extends BaseAuthenticationContextTest {
    private SimpleSubjectCanonicalization action;

    @Override
    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        this.action = new SimpleSubjectCanonicalization();
        this.action.setTransforms(Arrays.asList(new Pair((Object)"^(.+)@osu\\.edu$", (Object)"$1")));
        this.action.initialize();
    }

    @Test
    public void testNoContext() {
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSubjectCanonicalizationContext");
    }

    @Test
    public void testNoPrincipal() {
        Subject subject = new Subject();
        ((SubjectCanonicalizationContext)this.prc.ensureSubcontext(SubjectCanonicalizationContext.class)).setSubject(subject);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSubject");
        SubjectCanonicalizationContext scc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        assert (scc != null);
        Assert.assertNotNull((Object)scc.getException());
    }

    @Test
    public void testMultiPrincipals() {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new UsernamePrincipal("foo"));
        subject.getPrincipals().add((Principal)new UsernamePrincipal("bar"));
        ((SubjectCanonicalizationContext)this.prc.ensureSubcontext(SubjectCanonicalizationContext.class)).setSubject(subject);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSubject");
        SubjectCanonicalizationContext scc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        assert (scc != null);
        Assert.assertNotNull((Object)scc.getException());
    }

    @Test
    public void testSuccess() {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new UsernamePrincipal("foo"));
        ((SubjectCanonicalizationContext)this.prc.ensureSubcontext(SubjectCanonicalizationContext.class)).setSubject(subject);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SubjectCanonicalizationContext sc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        assert (sc != null);
        Assert.assertEquals((String)sc.getPrincipalName(), (String)"foo");
    }

    @Test
    public void testTransform() {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new UsernamePrincipal("foo@osu.edu"));
        ((SubjectCanonicalizationContext)this.prc.ensureSubcontext(SubjectCanonicalizationContext.class)).setSubject(subject);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SubjectCanonicalizationContext sc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        assert (sc != null);
        Assert.assertEquals((String)sc.getPrincipalName(), (String)"foo");
    }
}

