/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.time.Duration;
import java.util.List;
import java.util.function.Function;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.LockoutManagerContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.idp.authn.impl.StorageBackedAccountLockoutManager;
import net.shibboleth.idp.authn.impl.testing.BaseAuthenticationContextTest;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.testing.ConstantSupplier;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class StorageBackedAccountLockoutManagerTest
extends BaseAuthenticationContextTest {
    private StorageBackedAccountLockoutManager manager;

    @Override
    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        MemoryStorageService ss = new MemoryStorageService();
        ss.setId("test");
        ss.initialize();
        StorageBackedAccountLockoutManager.UsernameIPLockoutKeyStrategy keyStrategy = new StorageBackedAccountLockoutManager.UsernameIPLockoutKeyStrategy();
        HttpServletRequest request = (HttpServletRequest)this.src.getExternalContext().getNativeRequest();
        keyStrategy.setHttpServletRequestSupplier((NonnullSupplier)new ConstantSupplier((Object)request));
        this.manager = new StorageBackedAccountLockoutManager();
        this.manager.setId("test");
        this.manager.setStorageService((StorageService)ss);
        this.manager.setLockoutKeyStrategy((Function)keyStrategy);
        this.manager.setMaxAttempts(3);
        this.manager.setCounterInterval(Duration.ofSeconds(3L));
        this.manager.setLockoutDuration(Duration.ofSeconds(5L));
        this.manager.initialize();
        ((MockHttpServletRequest)this.src.getExternalContext().getNativeRequest()).setRemoteAddr("192.168.1.1");
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        ((UsernamePasswordContext)authCtx.ensureSubcontext(UsernamePasswordContext.class)).setUsername("jdoe");
    }

    @Test
    public void noKey() {
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        authCtx.clearSubcontexts();
        Assert.assertFalse((boolean)this.manager.check(this.prc));
        Assert.assertFalse((boolean)this.manager.increment(this.prc));
        Assert.assertFalse((boolean)this.manager.clear(this.prc));
    }

    @Test
    public void one() {
        Assert.assertFalse((boolean)this.manager.check(this.prc));
        Assert.assertTrue((boolean)this.manager.increment(this.prc));
        Assert.assertFalse((boolean)this.manager.check(this.prc));
        Assert.assertTrue((boolean)this.manager.clear(this.prc));
    }

    @Test
    public void two() {
        Assert.assertTrue((boolean)this.manager.increment(this.prc));
        Assert.assertTrue((boolean)this.manager.increment(this.prc));
        Assert.assertFalse((boolean)this.manager.check(this.prc));
        Assert.assertTrue((boolean)this.manager.clear(this.prc));
    }

    @Test
    public void threeSlow() throws InterruptedException {
        Assert.assertTrue((boolean)this.manager.increment(this.prc));
        Assert.assertTrue((boolean)this.manager.increment(this.prc));
        Thread.sleep(4000L);
        Assert.assertTrue((boolean)this.manager.increment(this.prc));
        Assert.assertFalse((boolean)this.manager.check(this.prc));
        Assert.assertTrue((boolean)this.manager.clear(this.prc));
    }

    @Test
    public void threeFast() throws InterruptedException {
        Assert.assertTrue((boolean)this.manager.increment(this.prc));
        Assert.assertTrue((boolean)this.manager.increment(this.prc));
        Assert.assertTrue((boolean)this.manager.increment(this.prc));
        Assert.assertTrue((boolean)this.manager.check(this.prc));
        Thread.sleep(2000L);
        Assert.assertTrue((boolean)this.manager.check(this.prc));
    }

    @Test
    public void waitForUnlock() throws InterruptedException {
        Assert.assertTrue((boolean)this.manager.increment(this.prc));
        Assert.assertTrue((boolean)this.manager.increment(this.prc));
        Assert.assertTrue((boolean)this.manager.increment(this.prc));
        Assert.assertTrue((boolean)this.manager.check(this.prc));
        Thread.sleep(4000L);
        Assert.assertTrue((boolean)this.manager.check(this.prc));
        Thread.sleep(1150L);
        Assert.assertFalse((boolean)this.manager.check(this.prc));
    }

    @Test
    public void testEnum() {
        Assert.assertTrue((boolean)this.manager.increment(this.prc));
        Assert.assertTrue((boolean)this.manager.increment(this.prc));
        Assert.assertTrue((boolean)this.manager.increment(this.prc));
        Assert.assertTrue((boolean)this.manager.check(this.prc));
        ((MockHttpServletRequest)this.src.getExternalContext().getNativeRequest()).setRemoteAddr("192.168.1.2");
        Assert.assertTrue((boolean)this.manager.increment(this.prc));
        Assert.assertTrue((boolean)this.manager.increment(this.prc));
        Assert.assertTrue((boolean)this.manager.increment(this.prc));
        Assert.assertTrue((boolean)this.manager.check(this.prc));
        ((LockoutManagerContext)this.prc.ensureSubcontext(LockoutManagerContext.class)).setKey("jdoe!");
        List candidates = CollectionSupport.listOf((Object)"jdoe!192.168.1.1", (Object)"jdoe!192.168.1.2");
        Iterable keys = this.manager.enumerate(this.prc);
        for (String key : keys) {
            Assert.assertTrue((boolean)candidates.contains(key));
        }
    }
}

