/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.Principal;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.impl.BaseMultiFactorAuthenticationContextTest;
import net.shibboleth.idp.authn.impl.TransitionMultiFactorAuthentication;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TransitionMultiFactorAuthenticationTest
extends BaseMultiFactorAuthenticationContextTest {
    private TransitionMultiFactorAuthentication action;

    @Override
    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        this.action = new TransitionMultiFactorAuthentication();
        this.action.initialize();
    }

    @Test
    public void testNoResult() {
        this.mfa.setNextFlowId("authn/test2");
        this.mfa.setEvent("Foo");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"Foo");
        Assert.assertNull((Object)this.mfa.getNextFlowId());
    }

    @Test
    public void testTransitions() {
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((String)this.mfa.getNextFlowId(), (String)"authn/test1");
        Assert.assertNull((Object)this.ac.getAuthenticationResult());
        this.ac.setAuthenticationResult(new AuthenticationResult("authn/test1", (Principal)new UsernamePrincipal("foo")));
        event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((String)this.mfa.getNextFlowId(), (String)"interim");
        Assert.assertNull((Object)this.ac.getAuthenticationResult());
        event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((String)this.mfa.getNextFlowId(), (String)"authn/test2");
        Assert.assertNull((Object)this.ac.getAuthenticationResult());
        this.ac.setAuthenticationResult(new AuthenticationResult("authn/test2", (Principal)new UsernamePrincipal("foo2")));
        event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.mfa.getNextFlowId());
    }
}

