/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.HashMap;
import java.util.Set;
import java.util.function.Consumer;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.TemplateSearchDnResolver;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.AuthenticationErrorContext;
import net.shibboleth.idp.authn.context.LDAPResponseContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.idp.authn.impl.ExtractUsernamePasswordFromFormRequest;
import net.shibboleth.idp.authn.impl.HTPasswdCredentialValidator;
import net.shibboleth.idp.authn.impl.LDAPCredentialValidator;
import net.shibboleth.idp.authn.impl.ValidateCredentials;
import net.shibboleth.idp.authn.impl.testing.BaseAuthenticationContextTest;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.spring.resource.ResourceHelper;
import net.shibboleth.shared.testing.ConstantSupplier;
import net.shibboleth.shared.testing.InMemoryDirectory;
import net.shibboleth.shared.testing.VelocityEngine;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.auth.AuthenticationHandler;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResultCode;
import org.ldaptive.auth.Authenticator;
import org.ldaptive.auth.DnResolver;
import org.ldaptive.auth.SimpleBindAuthenticationHandler;
import org.ldaptive.jaas.LdapPrincipal;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ValidateCredentialsTest
extends BaseAuthenticationContextTest {
    private static final String DATA_PATH = "/net/shibboleth/idp/authn/impl/";
    private ValidateCredentials action;
    private InMemoryDirectory directoryServer;
    private TemplateSearchDnResolver dnResolver;
    private SimpleBindAuthenticationHandler authHandler;
    private Authenticator authenticator;

    @BeforeClass
    public void setupDirectoryServer() {
        this.directoryServer = new InMemoryDirectory(new String[]{"dc=shibboleth,dc=net"}, (Resource)new ClassPathResource("/net/shibboleth/idp/authn/impl/loginLDAPTest.ldif"), 10389);
        this.directoryServer.start();
    }

    @BeforeClass
    public void setupAuthenticator() {
        this.dnResolver = new TemplateSearchDnResolver((ConnectionFactory)new DefaultConnectionFactory("ldap://localhost:10389"), VelocityEngine.newVelocityEngine(), "(uid=$usernamePasswordContext.username)");
        this.dnResolver.setBaseDn("ou=people,dc=shibboleth,dc=net");
        this.authHandler = new SimpleBindAuthenticationHandler((ConnectionFactory)new DefaultConnectionFactory("ldap://localhost:10389"));
        this.authenticator = new Authenticator((DnResolver)this.dnResolver, (AuthenticationHandler)this.authHandler);
    }

    @AfterClass
    public void teardownDirectoryServer() throws Exception {
        if (this.directoryServer.openConnectionCount() > 0L) {
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)this.directoryServer.openConnectionCount(), (long)0L);
        this.directoryServer.stop(true);
    }

    @Override
    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        LDAPCredentialValidator ldap = new LDAPCredentialValidator();
        ldap.setId("ldap");
        assert (this.authenticator != null);
        ldap.setAuthenticator(this.authenticator);
        ldap.initialize();
        HTPasswdCredentialValidator htpasswd = new HTPasswdCredentialValidator();
        htpasswd.setId("htpasswd");
        htpasswd.setResource(ResourceHelper.of((Resource)new ClassPathResource("/net/shibboleth/idp/authn/impl/htpasswd.txt")));
        htpasswd.initialize();
        this.action = new ValidateCredentials();
        this.action.setValidators(CollectionSupport.listOf((Object)ldap, (Object)htpasswd));
        HashMap mappings = new HashMap();
        mappings.put("UnknownUsername", CollectionSupport.singleton((Object)"DN_RESOLUTION_FAILURE"));
        mappings.put("InvalidPassword", CollectionSupport.singleton((Object)"INVALID_CREDENTIALS"));
        mappings.put("InvalidPassword", CollectionSupport.singleton((Object)"InvalidCredentials"));
        mappings.put("ExpiringPassword", CollectionSupport.singleton((Object)"ACCOUNT_WARNING"));
        mappings.put("ExpiredPassword", CollectionSupport.listOf((Object)"PASSWORD_EXPIRED", (Object)"CHANGE_AFTER_RESET"));
        this.action.setClassifiedMessages(mappings);
        MockHttpServletRequest request = new MockHttpServletRequest();
        this.action.setHttpServletRequestSupplier((NonnullSupplier)new ConstantSupplier((Object)request));
    }

    @Test
    public void testBadUsername() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "foo");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "bar");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        Assert.assertNull((Object)ac.getAuthenticationResult());
        LDAPResponseContext lrc = (LDAPResponseContext)ac.getSubcontext(LDAPResponseContext.class);
        assert (lrc != null);
        AuthenticationResponse lar = lrc.getAuthenticationResponse();
        assert (lar != null);
        Assert.assertEquals((Object)lar.getAuthenticationResultCode(), (Object)AuthenticationResultCode.DN_RESOLUTION_FAILURE);
        AuthenticationErrorContext aec = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        assert (aec != null);
        ActionTestingSupport.assertEvent((Event)event, (String)"UnknownUsername");
        Assert.assertEquals((int)aec.getClassifiedErrors().size(), (int)1);
        Assert.assertTrue((boolean)aec.isClassifiedError("UnknownUsername"));
    }

    @Test
    public void testEmptyPassword() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        Assert.assertNull((Object)ac.getAuthenticationResult());
        AuthenticationErrorContext aec = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        assert (aec != null);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidPassword");
        Assert.assertEquals((int)aec.getClassifiedErrors().size(), (int)1);
        Assert.assertTrue((boolean)aec.isClassifiedError("InvalidPassword"));
    }

    @Test
    public void testBadPassword() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "bar");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        Assert.assertNull((Object)ac.getAuthenticationResult());
        LDAPResponseContext lrc = (LDAPResponseContext)ac.getSubcontext(LDAPResponseContext.class);
        assert (lrc != null);
        AuthenticationResponse lar = lrc.getAuthenticationResponse();
        assert (lar != null);
        Assert.assertEquals((Object)lar.getAuthenticationResultCode(), (Object)AuthenticationResultCode.AUTHENTICATION_HANDLER_FAILURE);
        AuthenticationErrorContext aec = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        assert (aec != null);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidPassword");
        Assert.assertEquals((int)aec.getClassifiedErrors().size(), (int)2);
        Assert.assertTrue((boolean)aec.isClassifiedError("InvalidPassword"));
        Assert.assertTrue((boolean)aec.isClassifiedError("InvalidCredentials"));
    }

    @Test
    public void testAuthorized() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "changeit");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)ac.getSubcontext(UsernamePasswordContext.class));
        AuthenticationErrorContext aec = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        Assert.assertNull((Object)aec);
        AuthenticationResult result = ac.getAuthenticationResult();
        assert (result != null);
        LDAPResponseContext lrc = (LDAPResponseContext)ac.getSubcontext(LDAPResponseContext.class);
        assert (lrc != null);
        AuthenticationResponse lar = lrc.getAuthenticationResponse();
        assert (lar != null);
        Assert.assertEquals((Object)lar.getAuthenticationResultCode(), (Object)AuthenticationResultCode.AUTHENTICATION_HANDLER_SUCCESS);
        UsernamePrincipal up = result.getSubject().getPrincipals(UsernamePrincipal.class).iterator().next();
        Assert.assertNotNull((Object)up);
        Assert.assertEquals((String)up.getName(), (String)"PETER_THE_PRINCIPAL");
        LdapPrincipal lp = result.getSubject().getPrincipals(LdapPrincipal.class).iterator().next();
        Assert.assertNotNull((Object)lp);
        Assert.assertEquals((String)lp.getName(), (String)"PETER_THE_PRINCIPAL");
        Assert.assertNotNull((Object)lp.getLdapEntry());
    }

    @Test
    public void testAuthorized2() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL2");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "changeit");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.action.setCleanupHook((Consumer)new ValidateCredentials.UsernamePasswordCleanupHook());
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)ac.getSubcontext(UsernamePasswordContext.class));
        AuthenticationResult result = ac.getAuthenticationResult();
        assert (result != null);
        UsernamePrincipal up = result.getSubject().getPrincipals(UsernamePrincipal.class).iterator().next();
        Assert.assertNotNull((Object)up);
        Assert.assertEquals((String)up.getName(), (String)"PETER_THE_PRINCIPAL2");
        Assert.assertTrue((boolean)result.getSubject().getPrincipals(LdapPrincipal.class).isEmpty());
        LDAPResponseContext lrc = (LDAPResponseContext)ac.getSubcontext(LDAPResponseContext.class);
        assert (lrc != null);
        AuthenticationResponse lar = lrc.getAuthenticationResponse();
        assert (lar != null);
        Assert.assertEquals((Object)lar.getAuthenticationResultCode(), (Object)AuthenticationResultCode.DN_RESOLUTION_FAILURE);
        AuthenticationErrorContext aec = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        assert (aec != null);
        Assert.assertEquals((int)aec.getClassifiedErrors().size(), (int)1);
        Assert.assertTrue((boolean)aec.isClassifiedError("UnknownUsername"));
    }

    @Test
    public void testBadPassword2() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL2");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "changeit");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.action.setRequireAll(true);
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        Assert.assertNull((Object)ac.getAuthenticationResult());
        LDAPResponseContext lrc = (LDAPResponseContext)ac.getSubcontext(LDAPResponseContext.class);
        assert (lrc != null);
        AuthenticationResponse lar = lrc.getAuthenticationResponse();
        assert (lar != null);
        Assert.assertEquals((Object)lar.getAuthenticationResultCode(), (Object)AuthenticationResultCode.DN_RESOLUTION_FAILURE);
        AuthenticationErrorContext aec = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        assert (aec != null);
        ActionTestingSupport.assertEvent((Event)event, (String)"UnknownUsername");
        Assert.assertEquals((int)aec.getClassifiedErrors().size(), (int)1);
        Assert.assertTrue((boolean)aec.isClassifiedError("UnknownUsername"));
    }

    @Test
    public void testAuthorizedAll() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("username", "PETER_THE_PRINCIPAL");
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).addParameter("password", "changeit");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.action.setRequireAll(true);
        this.action.setCleanupHook((Consumer)new ValidateCredentials.UsernamePasswordCleanupHook());
        this.action.initialize();
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)ac.getSubcontext(UsernamePasswordContext.class));
        AuthenticationErrorContext aec = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        Assert.assertNull((Object)aec);
        AuthenticationResult result = ac.getAuthenticationResult();
        assert (result != null);
        LDAPResponseContext lrc = (LDAPResponseContext)ac.getSubcontext(LDAPResponseContext.class);
        assert (lrc != null);
        AuthenticationResponse lar = lrc.getAuthenticationResponse();
        assert (lar != null);
        Assert.assertEquals((Object)lar.getAuthenticationResultCode(), (Object)AuthenticationResultCode.AUTHENTICATION_HANDLER_SUCCESS);
        Set<UsernamePrincipal> ups = result.getSubject().getPrincipals(UsernamePrincipal.class);
        Assert.assertEquals((int)ups.size(), (int)1);
        Assert.assertNotNull((Object)ups.iterator().next());
        Assert.assertEquals((String)ups.iterator().next().getName(), (String)"PETER_THE_PRINCIPAL");
        LdapPrincipal lp = result.getSubject().getPrincipals(LdapPrincipal.class).iterator().next();
        Assert.assertNotNull((Object)lp);
        Assert.assertEquals((String)lp.getName(), (String)"PETER_THE_PRINCIPAL");
        Assert.assertNotNull((Object)lp.getLdapEntry());
    }

    private void doExtract() throws ComponentInitializationException {
        ExtractUsernamePasswordFromFormRequest extract = new ExtractUsernamePasswordFromFormRequest();
        extract.setHttpServletRequestSupplier(this.action.getHttpServletRequestSupplier());
        extract.initialize();
        extract.execute(this.src);
    }
}

