/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.Principal;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.ExternalAuthentication;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.AuthenticationErrorContext;
import net.shibboleth.idp.authn.context.ExternalAuthenticationContext;
import net.shibboleth.idp.authn.impl.ExternalAuthenticationImpl;
import net.shibboleth.idp.authn.impl.ValidateExternalAuthentication;
import net.shibboleth.idp.authn.impl.testing.BaseAuthenticationContextTest;
import net.shibboleth.idp.authn.principal.ProxyAuthenticationPrincipal;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.authn.testing.TestPrincipal;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.testing.ConstantSupplier;
import org.opensaml.messaging.context.BaseContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ValidateExternalAuthenticationTest
extends BaseAuthenticationContextTest {
    private ExternalAuthentication ext;
    private ValidateExternalAuthentication action;

    @Override
    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.ext = new ExternalAuthenticationImpl();
        this.action = new ValidateExternalAuthentication();
        MockHttpServletRequest request = new MockHttpServletRequest();
        this.action.setHttpServletRequestSupplier((NonnullSupplier)new ConstantSupplier((Object)request));
        this.action.initialize();
    }

    @Test
    public void testMissingFlow() {
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow(null);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidAuthenticationContext");
    }

    @Test
    public void testMissingContext() {
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidAuthenticationContext");
    }

    @Test
    public void testNoCredentials() {
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.addSubcontext((BaseContext)new ExternalAuthenticationContext(this.ext), true);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"NoCredentials");
    }

    @Test
    public void testPrincipalName() {
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ExternalAuthenticationContext eac = (ExternalAuthenticationContext)ac.addSubcontext((BaseContext)new ExternalAuthenticationContext(this.ext), true);
        eac.setPrincipalName("foo");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationResult ar = ac.getAuthenticationResult();
        assert (ar != null);
        Assert.assertFalse((boolean)ar.isPreviousResult());
        Assert.assertEquals((String)ar.getSubject().getPrincipals(UsernamePrincipal.class).iterator().next().getName(), (String)"foo");
    }

    @Test
    public void testPrincipal() {
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ExternalAuthenticationContext eac = (ExternalAuthenticationContext)ac.addSubcontext((BaseContext)new ExternalAuthenticationContext(this.ext), true);
        eac.setPrincipal((Principal)new TestPrincipal("foo"));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationResult ar = ac.getAuthenticationResult();
        assert (ar != null);
        Assert.assertFalse((boolean)ar.isPreviousResult());
        Assert.assertEquals((String)ar.getSubject().getPrincipals(TestPrincipal.class).iterator().next().getName(), (String)"foo");
    }

    @Test
    public void testSubject() {
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ExternalAuthenticationContext eac = (ExternalAuthenticationContext)ac.addSubcontext((BaseContext)new ExternalAuthenticationContext(this.ext), true);
        Subject subject = new Subject();
        eac.setSubject(subject);
        subject.getPrincipals().add((Principal)new TestPrincipal("foo"));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationResult ar = ac.getAuthenticationResult();
        assert (ar != null);
        Assert.assertFalse((boolean)ar.isPreviousResult());
        Assert.assertEquals((String)ar.getSubject().getPrincipals(TestPrincipal.class).iterator().next().getName(), (String)"foo");
    }

    @Test
    public void testAuthnInstant() {
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ExternalAuthenticationContext eac = (ExternalAuthenticationContext)ac.addSubcontext((BaseContext)new ExternalAuthenticationContext(this.ext), true);
        eac.setPrincipalName("foo");
        Instant ts = Instant.now().minusSeconds(3600L);
        eac.setAuthnInstant(ts);
        eac.setPreviousResult(true);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationResult ar = ac.getAuthenticationResult();
        assert (ar != null);
        Assert.assertTrue((boolean)ar.isPreviousResult());
        Assert.assertEquals((Object)ts, (Object)ar.getAuthenticationInstant());
    }

    @Test
    public void testAuthnAuthorities() {
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ExternalAuthenticationContext eac = (ExternalAuthenticationContext)ac.addSubcontext((BaseContext)new ExternalAuthenticationContext(this.ext), true);
        eac.setPrincipalName("foo");
        eac.getAuthenticatingAuthorities().addAll(Arrays.asList("foo", "bar", "baz"));
        eac.setPreviousResult(true);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationResult ar = ac.getAuthenticationResult();
        assert (ar != null);
        Assert.assertTrue((boolean)ar.isPreviousResult());
        Set<ProxyAuthenticationPrincipal> prin = ar.getSubject().getPrincipals(ProxyAuthenticationPrincipal.class);
        Assert.assertEquals((int)prin.size(), (int)1);
        Assert.assertEquals((Collection)prin.iterator().next().getAuthorities(), Arrays.asList("foo", "bar", "baz"));
    }

    @Test
    public void testException() {
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ExternalAuthenticationContext eac = (ExternalAuthenticationContext)ac.addSubcontext((BaseContext)new ExternalAuthenticationContext(this.ext), true);
        eac.setAuthnException((Exception)new LoginException("foo"));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"AuthenticationException");
        AuthenticationErrorContext aec = (AuthenticationErrorContext)ac.getSubcontext(AuthenticationErrorContext.class);
        assert (aec != null);
        Assert.assertEquals((int)aec.getExceptions().size(), (int)1);
    }

    @Test
    public void testError() {
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ExternalAuthenticationContext eac = (ExternalAuthenticationContext)ac.addSubcontext((BaseContext)new ExternalAuthenticationContext(this.ext), true);
        eac.setAuthnError("foo");
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"AuthenticationException");
        Assert.assertNull((Object)ac.getAuthenticationResult());
    }
}

