/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import com.google.common.base.Functions;
import java.security.Principal;
import java.util.function.Function;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.impl.ValidateFunctionResult;
import net.shibboleth.idp.authn.impl.testing.BaseAuthenticationContextTest;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.authn.testing.TestPrincipal;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.FunctionSupport;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ValidateFunctionResultTest
extends BaseAuthenticationContextTest {
    private ValidateFunctionResult action;

    @Override
    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.action = new ValidateFunctionResult();
    }

    @Test
    public void testMissingFlow() throws ComponentInitializationException {
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow(null);
        this.action.setResultLookupStrategy(FunctionSupport.constant(null));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidAuthenticationContext");
    }

    @Test
    public void testNoCredentials() throws ComponentInitializationException {
        this.action.setResultLookupStrategy(FunctionSupport.constant(null));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"NoCredentials");
    }

    @Test
    public void testInvalidType() throws ComponentInitializationException {
        this.action.setResultLookupStrategy((Function)Functions.identity());
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"NoCredentials");
    }

    @Test
    public void testPrincipalName() throws ComponentInitializationException {
        this.action.setResultLookupStrategy(FunctionSupport.constant((Object)"foo"));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        AuthenticationResult ar = ac.getAuthenticationResult();
        assert (ar != null);
        Assert.assertFalse((boolean)ar.isPreviousResult());
        Assert.assertEquals((String)ar.getSubject().getPrincipals(UsernamePrincipal.class).iterator().next().getName(), (String)"foo");
    }

    @Test
    public void testPrincipal() throws ComponentInitializationException {
        this.action.setResultLookupStrategy(FunctionSupport.constant((Object)new TestPrincipal("foo")));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        AuthenticationResult ar = ac.getAuthenticationResult();
        assert (ar != null);
        Assert.assertFalse((boolean)ar.isPreviousResult());
        Assert.assertEquals((String)ar.getSubject().getPrincipals(TestPrincipal.class).iterator().next().getName(), (String)"foo");
    }

    @Test
    public void testSubject() throws ComponentInitializationException {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new TestPrincipal("foo"));
        this.action.setResultLookupStrategy(FunctionSupport.constant((Object)subject));
        this.action.initialize();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        AuthenticationResult ar = ac.getAuthenticationResult();
        assert (ar != null);
        Assert.assertFalse((boolean)ar.isPreviousResult());
        Assert.assertEquals((String)ar.getSubject().getPrincipals(TestPrincipal.class).iterator().next().getName(), (String)"foo");
    }
}

