/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.Collection;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.impl.ExtractUserAgentAddress;
import net.shibboleth.idp.authn.impl.ValidateUserAgentAddress;
import net.shibboleth.idp.authn.impl.testing.BaseAuthenticationContextTest;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactory;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.authn.principal.impl.ExactPrincipalEvalPredicateFactory;
import net.shibboleth.idp.authn.testing.TestPrincipal;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.net.IPRange;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.testing.ConstantSupplier;
import org.opensaml.messaging.context.BaseContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ValidateUserAgentAddressTest
extends BaseAuthenticationContextTest {
    private ValidateUserAgentAddress action;
    private Object nullObj;

    @Override
    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        this.action = new ValidateUserAgentAddress();
        this.action.setMappings(CollectionSupport.singletonMap((Object)"foo", (Object)CollectionSupport.singletonList((Object)IPRange.parseCIDRBlock((String)"192.168.1.0/24"))));
        this.action.setSupportedPrincipals((Collection)CollectionSupport.singletonList((Object)new TestPrincipal("UserAgentAuthentication")));
        MockHttpServletRequest request = new MockHttpServletRequest();
        this.action.setHttpServletRequestSupplier((NonnullSupplier)new ConstantSupplier((Object)request));
        this.action.initialize();
    }

    @Test
    public void testMissingFlow() {
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidAuthenticationContext");
    }

    @Test
    public void testMissingAddress() {
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"NoCredentials");
    }

    @Test
    public void testMissingAddress2() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).setRemoteAddr((String)this.nullObj);
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"NoCredentials");
    }

    @Test
    public void testUnauthorized() throws ComponentInitializationException {
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidCredentials");
    }

    @Test
    public void testIncompatible() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).setRemoteAddr("192.168.1.1");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        RequestedPrincipalContext rpc = new RequestedPrincipalContext();
        rpc.getPrincipalEvalPredicateFactoryRegistry().register(TestPrincipal.class, "exact", (PrincipalEvalPredicateFactory)new ExactPrincipalEvalPredicateFactory());
        rpc.setOperator("exact");
        rpc.setRequestedPrincipals(CollectionSupport.singletonList((Object)new TestPrincipal("PasswordAuthentication")));
        ac.addSubcontext((BaseContext)rpc, true);
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"RequestUnsupported");
    }

    @Test
    public void testCompatible() throws ComponentInitializationException {
        this.getMockHttpServletRequest((AbstractAuthenticationAction)this.action).setRemoteAddr("192.168.1.1");
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow((AuthenticationFlowDescriptor)this.authenticationFlows.get(0));
        RequestedPrincipalContext rpc = new RequestedPrincipalContext();
        rpc.getPrincipalEvalPredicateFactoryRegistry().register(TestPrincipal.class, "exact", (PrincipalEvalPredicateFactory)new ExactPrincipalEvalPredicateFactory());
        rpc.setOperator("exact");
        rpc.setRequestedPrincipals(CollectionSupport.singletonList((Object)new TestPrincipal("UserAgentAuthentication")));
        ac.addSubcontext((BaseContext)rpc, true);
        this.doExtract();
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AuthenticationResult ar = ac.getAuthenticationResult();
        assert (ar != null);
        Assert.assertEquals((String)ar.getSubject().getPrincipals(UsernamePrincipal.class).iterator().next().getName(), (String)"foo");
    }

    private void doExtract() throws ComponentInitializationException {
        ExtractUserAgentAddress extract = new ExtractUserAgentAddress();
        extract.setHttpServletRequestSupplier(this.action.getHttpServletRequestSupplier());
        extract.initialize();
        extract.execute(this.src);
    }
}

