/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.Arrays;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.impl.X500SubjectCanonicalization;
import net.shibboleth.idp.authn.impl.testing.BaseAuthenticationContextTest;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class X500SubjectCanonicalizationTest
extends BaseAuthenticationContextTest {
    private X500SubjectCanonicalization action;

    @Override
    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        this.action = new X500SubjectCanonicalization();
        this.action.setTransforms(Arrays.asList(new Pair((Object)"^(.+)@osu\\.edu$", (Object)"$1")));
        this.action.setObjectIds(Arrays.asList("1.2.840.113549.1.9.1", "0.9.2342.19200300.100.1.1"));
        this.action.initialize();
    }

    @Test
    public void testNoContext() {
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSubjectCanonicalizationContext");
    }

    @Test
    public void testNoPrincipal() {
        Subject subject = new Subject();
        ((SubjectCanonicalizationContext)this.prc.ensureSubcontext(SubjectCanonicalizationContext.class)).setSubject(subject);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSubject");
        SubjectCanonicalizationContext scc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        assert (scc != null);
        Assert.assertNotNull((Object)scc.getException());
    }

    @Test
    public void testMultiPrincipals() {
        Subject subject = new Subject();
        subject.getPrincipals().add(new X500Principal("CN=foo"));
        subject.getPrincipals().add(new X500Principal("CN=bar"));
        ((SubjectCanonicalizationContext)this.prc.ensureSubcontext(SubjectCanonicalizationContext.class)).setSubject(subject);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSubject");
        SubjectCanonicalizationContext scc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        assert (scc != null);
        Assert.assertNotNull((Object)scc.getException());
    }

    @Test
    public void testNone() {
        Subject subject = new Subject();
        subject.getPrincipals().add(new X500Principal("CN=foo@example.edu"));
        ((SubjectCanonicalizationContext)this.prc.ensureSubcontext(SubjectCanonicalizationContext.class)).setSubject(subject);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSubject");
        SubjectCanonicalizationContext sc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        assert (sc != null && sc.getPrincipalName() == null);
    }

    @Test
    public void testSuccess() {
        Subject subject = new Subject();
        subject.getPrincipals().add(new X500Principal("EMAILADDRESS=foo@example.edu"));
        ((SubjectCanonicalizationContext)this.prc.ensureSubcontext(SubjectCanonicalizationContext.class)).setSubject(subject);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SubjectCanonicalizationContext sc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        assert (sc != null);
        Assert.assertEquals((String)sc.getPrincipalName(), (String)"foo@example.edu");
    }

    @Test
    public void testComplex() {
        Subject subject = new Subject();
        subject.getPrincipals().add(new X500Principal("EMAILADDRESS=foo@example.edu\\, EMAILADDRESS=bar@example.edu"));
        ((SubjectCanonicalizationContext)this.prc.ensureSubcontext(SubjectCanonicalizationContext.class)).setSubject(subject);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SubjectCanonicalizationContext sc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        assert (sc != null);
        Assert.assertEquals((String)sc.getPrincipalName(), (String)"foo@example.edu, EMAILADDRESS=bar@example.edu");
    }

    @Test
    public void testTransform() {
        Subject subject = new Subject();
        subject.getPrincipals().add(new X500Principal("EMAILADDRESS=foo@osu.edu"));
        ((SubjectCanonicalizationContext)this.prc.ensureSubcontext(SubjectCanonicalizationContext.class)).setSubject(subject);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SubjectCanonicalizationContext sc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        assert (sc != null);
        Assert.assertEquals((String)sc.getPrincipalName(), (String)"foo");
    }

    @Test
    public void testMultipleTypes() {
        Subject subject = new Subject();
        subject.getPrincipals().add(new X500Principal("EMAILADDRESS=foo@example.edu, 0.9.2342.19200300.100.1.1=bar@example.edu"));
        ((SubjectCanonicalizationContext)this.prc.ensureSubcontext(SubjectCanonicalizationContext.class)).setSubject(subject);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SubjectCanonicalizationContext sc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        assert (sc != null);
        Assert.assertEquals((String)sc.getPrincipalName(), (String)"foo@example.edu");
    }

    @Test
    public void testMultipleValues() {
        Subject subject = new Subject();
        subject.getPrincipals().add(new X500Principal("EMAILADDRESS=foo@example.edu, EMAILADDRESS=bar@example.edu"));
        ((SubjectCanonicalizationContext)this.prc.ensureSubcontext(SubjectCanonicalizationContext.class)).setSubject(subject);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SubjectCanonicalizationContext sc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        assert (sc != null);
        Assert.assertEquals((String)sc.getPrincipalName(), (String)"foo@example.edu");
    }

    @Test
    public void testSecondary() {
        Subject subject = new Subject();
        subject.getPrincipals().add(new X500Principal("0.9.2342.19200300.100.1.1=bar@example.edu"));
        ((SubjectCanonicalizationContext)this.prc.ensureSubcontext(SubjectCanonicalizationContext.class)).setSubject(subject);
        Event event = this.action.execute(this.src);
        ActionTestingSupport.assertProceedEvent((Event)event);
        SubjectCanonicalizationContext scc = (SubjectCanonicalizationContext)this.prc.getSubcontext(SubjectCanonicalizationContext.class);
        assert (scc != null);
        Assert.assertEquals((String)scc.getPrincipalName(), (String)"bar@example.edu");
    }
}

