/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.io.File;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.impl.X509ResourceCredentialConfig;
import net.shibboleth.shared.spring.resource.ResourceHelper;
import org.ldaptive.ssl.SSLContextInitializer;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class X509ResourceCredentialConfigTest {
    private static final String DATAPATH = "/net/shibboleth/idp/authn/impl/";

    @DataProvider(name="resources")
    public Object[][] getResources() throws Exception {
        return new Object[][]{{X509ResourceCredentialConfigTest.getFileSystemResource("/net/shibboleth/idp/authn/impl/trust-certs.pem"), X509ResourceCredentialConfigTest.getFileSystemResource("/net/shibboleth/idp/authn/impl/auth-cert.pem"), X509ResourceCredentialConfigTest.getFileSystemResource("/net/shibboleth/idp/authn/impl/private-key.pem")}, {ResourceHelper.of((Resource)new ClassPathResource("/net/shibboleth/idp/authn/impl/trust-certs.pem")), ResourceHelper.of((Resource)new ClassPathResource("/net/shibboleth/idp/authn/impl/auth-cert.pem")), ResourceHelper.of((Resource)new ClassPathResource("/net/shibboleth/idp/authn/impl/private-key.pem"))}};
    }

    @Test(dataProvider="resources")
    public void createSSLContextInitializer(@Nonnull net.shibboleth.shared.resource.Resource trustCertificates, @Nonnull net.shibboleth.shared.resource.Resource authenticationCertificate, @Nonnull net.shibboleth.shared.resource.Resource authenticationKey) throws Exception {
        X509ResourceCredentialConfig config = new X509ResourceCredentialConfig();
        config.setTrustCertificates(trustCertificates);
        config.setAuthenticationCertificate(authenticationCertificate);
        config.setAuthenticationKey(authenticationKey);
        config.setAuthenticationKeyPassword("changeit");
        SSLContextInitializer init = config.createSSLContextInitializer();
        Assert.assertNotNull((Object)init.getTrustManagers()[0]);
        Assert.assertNotNull((Object)init.getKeyManagers()[0]);
    }

    private static net.shibboleth.shared.resource.Resource getFileSystemResource(String path) throws URISyntaxException {
        return ResourceHelper.of((Resource)new FileSystemResource(new File(X509ResourceCredentialConfigTest.class.getResource(path).toURI())));
    }
}

