/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl.testing;

import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.impl.PopulateAuthenticationContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.FunctionSupport;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.webflow.execution.RequestContext;

public class BaseAuthenticationContextTest
extends OpenSAMLInitBaseTestCase {
    protected RequestContext src;
    protected ProfileRequestContext prc;
    protected List<AuthenticationFlowDescriptor> authenticationFlows;

    protected void initializeMembers() throws ComponentInitializationException {
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
        this.prc.addSubcontext((BaseContext)new AuthenticationContext(), true);
        this.authenticationFlows = List.of(new AuthenticationFlowDescriptor(), new AuthenticationFlowDescriptor(), new AuthenticationFlowDescriptor());
        this.authenticationFlows.get(0).setId("test1");
        this.authenticationFlows.get(1).setId("test2");
        this.authenticationFlows.get(1).setPassiveAuthenticationSupported(true);
        this.authenticationFlows.get(2).setId("test3");
    }

    protected void setUp() throws ComponentInitializationException {
        this.initializeMembers();
        PopulateAuthenticationContext action = new PopulateAuthenticationContext();
        assert (this.authenticationFlows != null);
        action.setAvailableFlows(this.authenticationFlows);
        action.setPotentialFlowsLookupStrategy(FunctionSupport.constant(this.authenticationFlows));
        action.initialize();
        action.execute(this.src);
    }

    @Nonnull
    protected final MockHttpServletRequest getMockHttpServletRequest(AbstractAuthenticationAction action) {
        assert (action != null);
        HttpServletRequest req = action.getHttpServletRequest();
        assert (req != null);
        return (MockHttpServletRequest)req;
    }
}

