/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal.impl;

import java.security.Principal;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.authn.principal.impl.ExactPrincipalEvalPredicateFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ExactPrincipalEvalPredicateFactoryTest {
    private ExactPrincipalEvalPredicateFactory factory;
    private UsernamePrincipal foo;
    private UsernamePrincipal bar;

    @BeforeClass
    public void setUp() throws Exception {
        this.factory = new ExactPrincipalEvalPredicateFactory();
        this.foo = new UsernamePrincipal("foo");
        this.bar = new UsernamePrincipal("bar");
    }

    @Test
    public void testNoPrincipals() {
        AuthenticationResult sample = new AuthenticationResult("test", new Subject());
        Assert.assertFalse((boolean)this.factory.getPredicate((Principal)this.foo).test((Object)sample));
    }

    @Test
    public void testOnePrincipal() {
        AuthenticationResult sample = new AuthenticationResult("test", new Subject());
        sample.getSubject().getPrincipals().add((Principal)new UsernamePrincipal("foo"));
        Assert.assertTrue((boolean)this.factory.getPredicate((Principal)this.foo).test((Object)sample));
        Assert.assertFalse((boolean)this.factory.getPredicate((Principal)this.bar).test((Object)sample));
    }

    @Test
    public void testMultiplePrincipal() {
        AuthenticationResult sample = new AuthenticationResult("test", new Subject());
        sample.getSubject().getPrincipals().add((Principal)new UsernamePrincipal("foo"));
        sample.getSubject().getPrincipals().add((Principal)new UsernamePrincipal("baz"));
        Assert.assertTrue((boolean)this.factory.getPredicate((Principal)this.foo).test((Object)sample));
        Assert.assertFalse((boolean)this.factory.getPredicate((Principal)this.bar).test((Object)sample));
    }
}

