/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal.impl;

import java.security.Principal;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.authn.principal.impl.InexactPrincipalEvalPredicateFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class InexactPrincipalEvalPredicateFactoryTest {
    private InexactPrincipalEvalPredicateFactory factory;
    private UsernamePrincipal foo;
    private UsernamePrincipal bar;
    private UsernamePrincipal baz;

    @BeforeClass
    public void setUp() throws Exception {
        this.factory = new InexactPrincipalEvalPredicateFactory();
        this.factory.getMatchingRules().put((Object)"foo", (Object)"bar");
        this.factory.getMatchingRules().put((Object)"foo", (Object)"bar2");
        this.foo = new UsernamePrincipal("foo");
        this.bar = new UsernamePrincipal("bar");
        this.baz = new UsernamePrincipal("baz");
    }

    @Test
    public void testNoPrincipals() {
        AuthenticationResult sample = new AuthenticationResult("test", new Subject());
        Assert.assertFalse((boolean)this.factory.getPredicate((Principal)this.foo).test((Object)sample));
    }

    @Test
    public void testOnePrincipalMatch() {
        AuthenticationResult sample = new AuthenticationResult("test", new Subject());
        sample.getSubject().getPrincipals().add((Principal)new UsernamePrincipal("bar"));
        Assert.assertTrue((boolean)this.factory.getPredicate((Principal)this.foo).test((Object)sample));
        Assert.assertFalse((boolean)this.factory.getPredicate((Principal)this.bar).test((Object)sample));
        Assert.assertFalse((boolean)this.factory.getPredicate((Principal)this.baz).test((Object)sample));
    }

    @Test
    public void testOnePrincipalNoMatch() {
        AuthenticationResult sample = new AuthenticationResult("test", new Subject());
        sample.getSubject().getPrincipals().add((Principal)new UsernamePrincipal("foo"));
        Assert.assertFalse((boolean)this.factory.getPredicate((Principal)this.foo).test((Object)sample));
        Assert.assertFalse((boolean)this.factory.getPredicate((Principal)this.bar).test((Object)sample));
        Assert.assertFalse((boolean)this.factory.getPredicate((Principal)this.baz).test((Object)sample));
    }

    @Test
    public void testMultiplePrincipalMatch() {
        AuthenticationResult sample = new AuthenticationResult("test", new Subject());
        sample.getSubject().getPrincipals().add((Principal)new UsernamePrincipal("bar"));
        sample.getSubject().getPrincipals().add((Principal)new UsernamePrincipal("baz"));
        Assert.assertTrue((boolean)this.factory.getPredicate((Principal)this.foo).test((Object)sample));
        Assert.assertFalse((boolean)this.factory.getPredicate((Principal)this.bar).test((Object)sample));
        Assert.assertFalse((boolean)this.factory.getPredicate((Principal)this.baz).test((Object)sample));
    }

    @Test
    public void testMultiplePrincipalMatchMap() {
        AuthenticationResult sample = new AuthenticationResult("test", new Subject());
        sample.getSubject().getPrincipals().add((Principal)new UsernamePrincipal("bar"));
        sample.getSubject().getPrincipals().add((Principal)new UsernamePrincipal("baz"));
        InexactPrincipalEvalPredicateFactory mapFactory = new InexactPrincipalEvalPredicateFactory();
        mapFactory.setMatchingRules(this.factory.getMatchingRules().asMap());
        Assert.assertTrue((boolean)mapFactory.getPredicate((Principal)this.foo).test((Object)sample));
        Assert.assertFalse((boolean)mapFactory.getPredicate((Principal)this.bar).test((Object)sample));
        Assert.assertFalse((boolean)mapFactory.getPredicate((Principal)this.baz).test((Object)sample));
    }

    @Test
    public void testMultiplePrincipalNoMatch() {
        AuthenticationResult sample = new AuthenticationResult("test", new Subject());
        sample.getSubject().getPrincipals().add((Principal)new UsernamePrincipal("foo"));
        sample.getSubject().getPrincipals().add((Principal)new UsernamePrincipal("baz"));
        Assert.assertFalse((boolean)this.factory.getPredicate((Principal)this.foo).test((Object)sample));
        Assert.assertFalse((boolean)this.factory.getPredicate((Principal)this.bar).test((Object)sample));
        Assert.assertFalse((boolean)this.factory.getPredicate((Principal)this.baz).test((Object)sample));
    }
}

