/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal.impl;

import java.security.Principal;
import net.shibboleth.idp.authn.context.RequestedPrincipalContext;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactory;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.authn.principal.impl.ExactPrincipalEvalPredicateFactory;
import net.shibboleth.idp.authn.principal.impl.InexactPrincipalEvalPredicateFactory;
import net.shibboleth.shared.collection.CollectionSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RequestedPrincipalContextPrincipalEvalTest {
    private UsernamePrincipal foo;
    private UsernamePrincipal bar;
    private UsernamePrincipal baz;
    private RequestedPrincipalContext rpCtx;

    @BeforeClass
    public void setUp() throws Exception {
        InexactPrincipalEvalPredicateFactory factory = new InexactPrincipalEvalPredicateFactory();
        factory.getMatchingRules().put((Object)"foo", (Object)"bar");
        factory.getMatchingRules().put((Object)"foo", (Object)"bar2");
        this.rpCtx = new RequestedPrincipalContext();
        this.rpCtx.getPrincipalEvalPredicateFactoryRegistry().register(UsernamePrincipal.class, "better", (PrincipalEvalPredicateFactory)factory);
        this.rpCtx.getPrincipalEvalPredicateFactoryRegistry().register(UsernamePrincipal.class, "exact", (PrincipalEvalPredicateFactory)new ExactPrincipalEvalPredicateFactory());
        this.foo = new UsernamePrincipal("foo");
        this.bar = new UsernamePrincipal("bar");
        this.baz = new UsernamePrincipal("baz");
    }

    @Test
    public void testUnknownOperator() {
        this.rpCtx.setOperator("unknown");
        this.rpCtx.setRequestedPrincipals(CollectionSupport.singletonList((Object)this.foo));
        Assert.assertFalse((boolean)this.rpCtx.isAcceptable((Principal)this.foo));
    }

    @Test
    public void testExact() {
        this.rpCtx.setOperator("exact");
        this.rpCtx.setRequestedPrincipals(CollectionSupport.listOf((Object)this.foo, (Object)this.bar));
        Assert.assertTrue((boolean)this.rpCtx.isAcceptable((Principal)this.foo));
        Assert.assertTrue((boolean)this.rpCtx.isAcceptable((Principal)this.bar));
        Assert.assertFalse((boolean)this.rpCtx.isAcceptable((Principal)this.baz));
    }

    @Test
    public void testBetterKnown() {
        this.rpCtx.setOperator("better");
        this.rpCtx.setRequestedPrincipals(CollectionSupport.singletonList((Object)this.foo));
        Assert.assertFalse((boolean)this.rpCtx.isAcceptable((Principal)this.foo));
        Assert.assertTrue((boolean)this.rpCtx.isAcceptable((Principal)this.bar));
        Assert.assertFalse((boolean)this.rpCtx.isAcceptable((Principal)this.baz));
    }

    @Test
    public void testBetterUnknown() {
        this.rpCtx.setOperator("better");
        this.rpCtx.setRequestedPrincipals(CollectionSupport.singletonList((Object)this.bar));
        Assert.assertFalse((boolean)this.rpCtx.isAcceptable((Principal)this.foo));
        Assert.assertFalse((boolean)this.rpCtx.isAcceptable((Principal)this.bar));
        Assert.assertFalse((boolean)this.rpCtx.isAcceptable((Principal)this.baz));
    }
}

