/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal.impl;

import java.io.IOException;
import java.security.Principal;
import javax.security.auth.x500.X500Principal;
import net.shibboleth.idp.authn.principal.impl.X500PrincipalSerializer;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class X500PrincipalSerializerTest {
    X500PrincipalSerializer serializer;

    @BeforeClass
    public void setUp() {
        this.serializer = new X500PrincipalSerializer();
    }

    @Test
    public void testRoundTrip() throws IOException {
        X500Principal p1 = new X500Principal("DC=net, DC=shibboleth, CN=jdoe");
        String s = this.serializer.serialize((Principal)p1);
        Assert.assertTrue((boolean)this.serializer.supports(s));
        X500Principal p2 = this.serializer.deserialize(s);
        Assert.assertEquals((Object)p1, (Object)p2);
        assert (p2 != null);
        Assert.assertEquals((String)p2.getName(), (String)"DC=net,DC=shibboleth,CN=jdoe");
    }
}

