/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.proxy.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import net.shibboleth.idp.authn.impl.testing.BaseAuthenticationContextTest;
import net.shibboleth.idp.authn.proxy.impl.DiscoveryProfileRequestFunction;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.net.URISupport;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.test.MockFlowExecutionContext;
import org.springframework.webflow.test.MockFlowExecutionKey;
import org.springframework.webflow.test.MockRequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DiscoveryProfileRequestFunctionTest
extends BaseAuthenticationContextTest {
    private DiscoveryProfileRequestFunction function;

    @Override
    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        ((MockFlowExecutionContext)((MockRequestContext)this.src).getFlowExecutionContext()).setKey((FlowExecutionKey)new MockFlowExecutionKey("flowkey"));
        this.function = new DiscoveryProfileRequestFunction();
        this.function.setDiscoveryURLLookupStrategy(FunctionSupport.constant((Object)"https://ds.example.org/DS"));
        this.function.initialize();
    }

    @Test
    public void test() throws MalformedURLException {
        URL url = new URL(this.function.apply(this.src, this.prc));
        Assert.assertEquals((String)url.getProtocol(), (String)"https");
        Assert.assertEquals((String)url.getHost(), (String)"ds.example.org");
        Assert.assertEquals((int)url.getPort(), (int)-1);
        Assert.assertEquals((String)url.getPath(), (String)"/DS");
        List params = URISupport.parseQueryString((String)url.getQuery());
        Assert.assertEquals((int)params.size(), (int)2);
        HashMap map = new HashMap();
        params.forEach(p -> map.put((String)p.getFirst(), (String)p.getSecond()));
        Assert.assertEquals((String)((String)map.get("entityID")), (String)"http://idp.example.org");
        Assert.assertEquals((String)((String)map.get("return")), (String)"http://localhost?execution=flowkey&_eventId_proceed=1");
    }
}

