/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.proxy.impl;

import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.proxy.impl.InitializeProxyProfileRequestContext;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class InitializeProxyProfileRequestContextTest {
    private ProfileRequestContext prc;
    private InitializeProxyProfileRequestContext action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.prc = new RequestContextBuilder().buildProfileRequestContext();
        this.action = new InitializeProxyProfileRequestContext();
        this.action.setProfileId("nested");
        this.action.initialize();
    }

    @Test
    public void testFailure() throws Exception {
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidProfileContext");
    }

    @Test
    public void testSuccess() throws Exception {
        this.prc.addSubcontext((BaseContext)new AuthenticationContext());
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        AuthenticationContext ac = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ProfileRequestContext prc2 = (ProfileRequestContext)ac.getSubcontext(ProfileRequestContext.class);
        assert (prc2 != null);
        Assert.assertEquals((String)prc2.getProfileId(), (String)"nested");
    }
}

