/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.revocation.impl;

import java.time.Instant;
import java.util.Collection;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.security.auth.Subject;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.impl.testing.BaseAuthenticationContextTest;
import net.shibboleth.idp.authn.revocation.impl.AttributeRevocationCondition;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.service.ServiceableComponent;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AttributeRevocationConditionTest
extends BaseAuthenticationContextTest {
    private Collection<Instant> revocationsToResolve;
    private AttributeRevocationCondition condition;

    @Override
    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        this.condition = new AttributeRevocationCondition();
        this.condition.setPrincipalNameLookupStrategy(FunctionSupport.constant((Object)"jdoe"));
        this.condition.setAttributeResolver((ReloadableService)new MockResolver());
        this.condition.setAttributeId("revocation");
        this.condition.initialize();
        ((AuthenticationFlowDescriptor)this.authenticationFlows.get(1)).setRevocationCondition((BiPredicate)this.condition);
    }

    @AfterMethod
    public void tearDown() {
        this.condition.destroy();
    }

    @Test
    public void testNotRevoked() {
        AuthenticationResult active = ((AuthenticationFlowDescriptor)this.authenticationFlows.get(1)).newAuthenticationResult(new Subject());
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        authCtx.setActiveResults((Iterable)CollectionSupport.singletonList((Object)active));
        Assert.assertTrue((boolean)active.test(this.prc));
    }

    @Test
    public void testRevoked() {
        AuthenticationResult active = ((AuthenticationFlowDescriptor)this.authenticationFlows.get(1)).newAuthenticationResult(new Subject());
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        authCtx.setActiveResults((Iterable)CollectionSupport.singletonList((Object)active));
        this.revocationsToResolve = CollectionSupport.singletonList((Object)Instant.now().plusSeconds(3600L));
        Assert.assertFalse((boolean)active.test(this.prc));
    }

    @Test
    public void testPastRevoked() {
        AuthenticationResult active = ((AuthenticationFlowDescriptor)this.authenticationFlows.get(1)).newAuthenticationResult(new Subject());
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        authCtx.setActiveResults((Iterable)CollectionSupport.singletonList((Object)active));
        this.revocationsToResolve = CollectionSupport.singletonList((Object)Instant.now().minusSeconds(3600L));
        Assert.assertTrue((boolean)active.test(this.prc));
    }

    private class MockResolver
    implements ReloadableService<AttributeResolver> {
        private MockResolver() {
        }

        public boolean isInitialized() {
            return true;
        }

        public void initialize() throws ComponentInitializationException {
        }

        public Instant getLastSuccessfulReloadInstant() {
            return null;
        }

        public Instant getLastReloadAttemptInstant() {
            return null;
        }

        public Throwable getReloadFailureCause() {
            return null;
        }

        public void reload() {
        }

        @Nonnull
        public ServiceableComponent<AttributeResolver> getServiceableComponent() {
            return new ServiceableComponent<AttributeResolver>(){

                @Nonnull
                public AttributeResolver getComponent() {
                    return new AttributeResolver(){

                        public String getId() {
                            return "test";
                        }

                        public void resolveAttributes(@Nonnull AttributeResolutionContext resolutionContext) throws ResolutionException {
                            if ("jdoe".equals(resolutionContext.getPrincipal()) && AttributeRevocationConditionTest.this.revocationsToResolve != null) {
                                IdPAttribute attr = new IdPAttribute("revocation");
                                attr.setValues(AttributeRevocationConditionTest.this.revocationsToResolve.stream().map(i -> StringAttributeValue.valueOf((String)Long.toString(i.getEpochSecond()))).collect(Collectors.toUnmodifiableList()));
                                resolutionContext.setResolvedIdPAttributes((Collection)CollectionSupport.singletonList((Object)attr));
                            }
                        }
                    };
                }

                public void close() {
                }
            };
        }
    }
}

