/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.revocation.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.function.BiPredicate;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.impl.testing.BaseAuthenticationContextTest;
import net.shibboleth.idp.authn.revocation.impl.RevocationCacheCondition;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.FunctionSupport;
import org.opensaml.storage.RevocationCache;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.opensaml.storage.impl.StorageServiceRevocationCache;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RevocationCacheConditionTest
extends BaseAuthenticationContextTest {
    private MemoryStorageService storageService;
    private StorageServiceRevocationCache revocationCache;
    private RevocationCacheCondition condition;

    @Override
    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        super.setUp();
        this.storageService = new MemoryStorageService();
        this.storageService.setId("test");
        this.storageService.setCleanupInterval(Duration.ZERO);
        this.storageService.initialize();
        this.revocationCache = new StorageServiceRevocationCache();
        this.revocationCache.setStorage((StorageService)this.storageService);
        this.revocationCache.setId("test");
        this.revocationCache.initialize();
        this.condition = new RevocationCacheCondition();
        this.condition.setRevocationCache((RevocationCache)this.revocationCache);
        this.condition.setPrincipalNameLookupStrategy(FunctionSupport.constant((Object)"jdoe"));
        this.condition.initialize();
        ((AuthenticationFlowDescriptor)this.authenticationFlows.get(1)).setRevocationCondition((BiPredicate)this.condition);
    }

    @AfterMethod
    public void tearDown() {
        this.condition.destroy();
        this.revocationCache.destroy();
        this.storageService.destroy();
    }

    @Test
    public void testNotRevoked() {
        AuthenticationResult active = ((AuthenticationFlowDescriptor)this.authenticationFlows.get(1)).newAuthenticationResult(new Subject());
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        authCtx.setActiveResults((Iterable)CollectionSupport.singletonList((Object)active));
        Assert.assertTrue((boolean)active.test(this.prc));
    }

    @Test
    public void testRevoked() {
        AuthenticationResult active = ((AuthenticationFlowDescriptor)this.authenticationFlows.get(1)).newAuthenticationResult(new Subject());
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        authCtx.setActiveResults((Iterable)CollectionSupport.singletonList((Object)active));
        this.revocationCache.revoke("LoginFlowRevocation", "prin!jdoe", Long.toString(Instant.now().getEpochSecond() + 3600L), Duration.ofDays(1L));
        Assert.assertFalse((boolean)active.test(this.prc));
    }

    @Test
    public void testPastRevoked() {
        AuthenticationResult active = ((AuthenticationFlowDescriptor)this.authenticationFlows.get(1)).newAuthenticationResult(new Subject());
        AuthenticationContext authCtx = (AuthenticationContext)this.prc.getSubcontext(AuthenticationContext.class);
        assert (authCtx != null);
        authCtx.setActiveResults((Iterable)CollectionSupport.singletonList((Object)active));
        this.revocationCache.revoke("LoginFlowRevocation", "prin!jdoe", Long.toString(Instant.now().getEpochSecond() - 3600L), Duration.ofDays(1L));
        Assert.assertTrue((boolean)active.test(this.prc));
    }
}

