/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.spnego.impl;

import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.spnego.impl.KerberosRealmSettings;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class KerberosRealmSettingsTest {
    @Nonnull
    protected static final String SERVICE_PRINCIPAL = "HTTP/aai-logon.domain_a.com@DOMAIN_A.COM";
    @Nonnull
    protected static final String KEYTAB = "/opt/kerberos/http_domainA.keytab";
    @Nonnull
    protected static final String PASSWORD = "secret";
    private Object nullObj;

    @BeforeMethod
    public void setUp() throws Exception {
    }

    @Test
    public void testRequiredValues() throws Exception {
        KerberosRealmSettings realm = new KerberosRealmSettings();
        realm.setServicePrincipal(SERVICE_PRINCIPAL);
        realm.setKeytab(KEYTAB);
        realm.initialize();
        Assert.assertEquals((String)realm.getServicePrincipal(), (String)SERVICE_PRINCIPAL, (String)"Value for service principal is invalid.");
        Assert.assertEquals((String)realm.getKeytab(), (String)KEYTAB, (String)"Value for keytab is invalid.");
        Assert.assertNull((Object)realm.getPassword(), (String)"Value for password is not null.");
        realm = new KerberosRealmSettings();
        realm.setServicePrincipal(SERVICE_PRINCIPAL);
        realm.setPassword(PASSWORD);
        realm.initialize();
        Assert.assertEquals((String)realm.getServicePrincipal(), (String)SERVICE_PRINCIPAL, (String)"Value for principal is invalid.");
        Assert.assertNull((Object)realm.getKeytab(), (String)"Value for keytab is not null.");
        Assert.assertEquals((String)realm.getPassword(), (String)PASSWORD, (String)"Value for password is invalid.");
    }

    @Test
    public void testMutuallyExclusiveValues() throws Exception {
        try {
            KerberosRealmSettings realm = new KerberosRealmSettings();
            realm.setServicePrincipal(SERVICE_PRINCIPAL);
            realm.setKeytab(KEYTAB);
            realm.setPassword(PASSWORD);
            realm.initialize();
            Assert.fail((String)"Both keytab and password are set, but they are mutually exclusive.");
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
    }

    @Test
    public void testNotSettingKeytabOrPassword() throws Exception {
        KerberosRealmSettings realm;
        try {
            realm = new KerberosRealmSettings();
            realm.setServicePrincipal(SERVICE_PRINCIPAL);
            realm.initialize();
            Assert.fail((String)"Neither keytab nor password is set.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            realm = new KerberosRealmSettings();
            realm.setServicePrincipal(SERVICE_PRINCIPAL);
            realm.setKeytab(null);
            realm.setPassword(null);
            realm.initialize();
            Assert.fail((String)"keytab and password must not both be set to null.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            realm = new KerberosRealmSettings();
            realm.setServicePrincipal(SERVICE_PRINCIPAL);
            realm.setKeytab("   ");
            realm.setPassword("   ");
            realm.initialize();
            Assert.fail((String)"keytab and password must not both be set to empty string.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testSettingBothKeytabAndPassword() throws Exception {
        try {
            KerberosRealmSettings realm = new KerberosRealmSettings();
            realm.setServicePrincipal(SERVICE_PRINCIPAL);
            realm.setKeytab(KEYTAB);
            realm.setPassword(PASSWORD);
            realm.initialize();
            Assert.fail((String)"Both keytab and password are set.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testNullOrEmptyValues() throws Exception {
        KerberosRealmSettings realm;
        try {
            realm = new KerberosRealmSettings();
            realm.initialize();
            Assert.fail((String)"Required values are not set.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            realm = new KerberosRealmSettings();
            realm.setKeytab(KEYTAB);
            realm.initialize();
            Assert.fail((String)"domain must not be set to empty string.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            realm = new KerberosRealmSettings();
            realm.setServicePrincipal((String)this.nullObj);
            realm.setKeytab(KEYTAB);
            realm.initialize();
            Assert.fail((String)"principal must not be set to null.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            realm = new KerberosRealmSettings();
            realm.setServicePrincipal("   ");
            realm.setKeytab(KEYTAB);
            realm.initialize();
            Assert.fail((String)"principal must not be set to empty string.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

