/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.spnego.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.spnego.impl.KerberosRealmSettings;
import net.shibboleth.idp.authn.spnego.impl.KerberosSettings;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class KerberosSettingsTest {
    @Nonnull
    protected static final String SERVICE_PRINCIPAL = "HTTP/aai-logon.domain_a.com@DOMAIN_A.COM";
    @Nonnull
    protected static final String KEYTAB = "/opt/kerberos/http_domainA.keytab";
    protected List<KerberosRealmSettings> realms;
    private KerberosSettings settings;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.settings = new KerberosSettings();
        KerberosRealmSettings realm1 = new KerberosRealmSettings();
        realm1.setServicePrincipal(SERVICE_PRINCIPAL);
        realm1.setKeytab(KEYTAB);
        realm1.initialize();
        this.realms = new ArrayList<KerberosRealmSettings>();
        this.realms.add(realm1);
    }

    @Test
    public void testRequiredValues() {
        this.settings.setRealms(this.realms);
        Assert.assertEquals((Collection)this.settings.getRealms(), this.realms);
    }
}

