/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.spnego.impl;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.ExternalAuthentication;
import net.shibboleth.idp.authn.ExternalAuthenticationException;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.ExternalAuthenticationContext;
import net.shibboleth.idp.authn.impl.ExternalAuthenticationImpl;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.idp.authn.spnego.impl.GSSContextAcceptor;
import net.shibboleth.idp.authn.spnego.impl.KerberosRealmSettings;
import net.shibboleth.idp.authn.spnego.impl.KerberosSettings;
import net.shibboleth.idp.authn.spnego.impl.SPNEGOAuthnController;
import net.shibboleth.idp.authn.spnego.impl.SPNEGOContext;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.component.ComponentInitializationException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SPNEGOAuthnControllerTest {
    private static final String TEST_CONVERSATION_KEY = "e1s1";
    private static String NTLMSSP_HEADER_DATA;
    private static String NEGOTIATE_HEADER_DATA;
    private SPNEGOAuthnController controller = new SPNEGOAuthnController();
    private GSSContextAcceptor mockGSSContextAcceptor;
    private Object nullObject;
    private SPNEGOAuthnController mockedGSSController = new SPNEGOAuthnController(){

        @Nonnull
        protected GSSContextAcceptor createGSSContextAcceptor(@Nonnull SPNEGOContext spnegoCtx) throws GSSException {
            return SPNEGOAuthnControllerTest.this.mockGSSContextAcceptor;
        }
    };

    @BeforeClass
    public void init() throws EncodingException {
        NTLMSSP_HEADER_DATA = Base64Support.encode((byte[])new byte[]{78, 84, 76, 77, 83, 83, 80}, (boolean)false);
        NEGOTIATE_HEADER_DATA = Base64Support.encode((byte[])"testdata".getBytes(), (boolean)false);
    }

    @BeforeMethod
    public void setup() {
        this.mockGSSContextAcceptor = (GSSContextAcceptor)Mockito.mock(GSSContextAcceptor.class);
    }

    @Test(expectedExceptions={ExternalAuthenticationException.class})
    public void withoutConversationKeyParameter_startSPNEGO_shouldThrowExternalAuthenticationException() throws Exception {
        this.controller.startSPNEGO(TEST_CONVERSATION_KEY, (HttpServletRequest)this.buildConversationRequestContext(null).getExternalContext().getNativeRequest(), (HttpServletResponse)this.nullObject);
    }

    @Test(expectedExceptions={ExternalAuthenticationException.class})
    public void givenMismatchedKeys_startSPNEGO_shouldThrowExternalAuthenticationException() throws Exception {
        this.controller.startSPNEGO("e1s2", (HttpServletRequest)this.buildConversationRequestContext(TEST_CONVERSATION_KEY).getExternalContext().getNativeRequest(), (HttpServletResponse)this.nullObject);
    }

    @Test(expectedExceptions={ExternalAuthenticationException.class})
    public void givenNullKey_startSPNEGO_shouldReturnAuthenticationException() throws Exception {
        RequestContext req = this.buildConversationRequestContext(null);
        this.controller.startSPNEGO(TEST_CONVERSATION_KEY, (HttpServletRequest)((MockHttpServletRequest)req.getExternalContext().getNativeRequest()), (HttpServletResponse)((MockHttpServletResponse)req.getExternalContext().getNativeResponse()));
    }

    @Test
    public void withoutSPNEGOContext_startSPNEGO_shouldReturnAuthenticationError() throws Exception {
        RequestContext req = this.buildConversationRequestContext(TEST_CONVERSATION_KEY);
        ModelAndView mv = this.controller.startSPNEGO(TEST_CONVERSATION_KEY, (HttpServletRequest)((MockHttpServletRequest)req.getExternalContext().getNativeRequest()), (HttpServletResponse)((MockHttpServletResponse)req.getExternalContext().getNativeResponse()));
        this.assertAuthenticationError(req, mv, "InvalidAuthenticationContext");
    }

    @Test
    public void withoutKerberosSettings_startSPNEGO_shouldReturnAuthenticationError() throws Exception {
        RequestContext req = this.buildConversationRequestContext(TEST_CONVERSATION_KEY);
        ProfileRequestContext prc = (ProfileRequestContext)req.getConversationScope().get("opensamlProfileRequestContext");
        AuthenticationContext ac = (AuthenticationContext)prc.getSubcontext(AuthenticationContext.class);
        SPNEGOContext sc = new SPNEGOContext();
        assert (ac != null);
        ac.addSubcontext((BaseContext)sc);
        ModelAndView mv = this.controller.startSPNEGO(TEST_CONVERSATION_KEY, (HttpServletRequest)((MockHttpServletRequest)req.getExternalContext().getNativeRequest()), (HttpServletResponse)((MockHttpServletResponse)req.getExternalContext().getNativeResponse()));
        this.assertAuthenticationError(req, mv, "InvalidAuthenticationContext");
    }

    @Test
    public void givenKerberosSettings_startSPNEGO_shouldReturnModelAndView() throws Exception {
        RequestContext req = this.buildKerberosContextRequestContext();
        ModelAndView mv = this.controller.startSPNEGO(TEST_CONVERSATION_KEY, (HttpServletRequest)((MockHttpServletRequest)req.getExternalContext().getNativeRequest()), (HttpServletResponse)((MockHttpServletResponse)req.getExternalContext().getNativeResponse()));
        this.assertModelAndView(mv, req);
    }

    @Test
    public void givenKerberosSettings_startSPNEGO_shouldPreserveQueryString() throws Exception {
        RequestContext req = this.buildKerberosContextRequestContext();
        ((MockHttpServletRequest)req.getExternalContext().getNativeRequest()).setQueryString("dummy query string");
        ModelAndView mv = this.controller.startSPNEGO(TEST_CONVERSATION_KEY, (HttpServletRequest)((MockHttpServletRequest)req.getExternalContext().getNativeRequest()), (HttpServletResponse)((MockHttpServletResponse)req.getExternalContext().getNativeResponse()));
        this.assertModelAndView(mv, req);
    }

    @Test
    public void givenKerberosSettings_startSPNEGO_shouldReplyUnauthorizedNegotiate() throws Exception {
        RequestContext req = this.buildKerberosContextRequestContext();
        this.controller.startSPNEGO(TEST_CONVERSATION_KEY, (HttpServletRequest)((MockHttpServletRequest)req.getExternalContext().getNativeRequest()), (HttpServletResponse)((MockHttpServletResponse)req.getExternalContext().getNativeResponse()));
        this.assertResponseUnauthorizedNegotiate(req);
    }

    @Test
    public void withoutNegotiateToken_continueSPNEGO_shouldReturnModelAndView() throws Exception {
        RequestContext req = this.buildConversationRequestContext(TEST_CONVERSATION_KEY);
        ModelAndView mv = this.controller.continueSPNEGO(TEST_CONVERSATION_KEY, "Negotiate", (HttpServletRequest)req.getExternalContext().getNativeRequest(), (HttpServletResponse)req.getExternalContext().getNativeResponse());
        this.assertModelAndView(mv, req);
    }

    @Test
    public void withoutNegotiateToken_continueSPNEGO_shouldPreserveQueryString() throws Exception {
        RequestContext req = this.buildConversationRequestContext(TEST_CONVERSATION_KEY);
        ((MockHttpServletRequest)req.getExternalContext().getNativeRequest()).setQueryString("dummy query string");
        ModelAndView mv = this.controller.continueSPNEGO(TEST_CONVERSATION_KEY, "Negotiate", (HttpServletRequest)req.getExternalContext().getNativeRequest(), (HttpServletResponse)req.getExternalContext().getNativeResponse());
        this.assertModelAndView(mv, req);
    }

    @Test
    public void withoutNegotiateToken_continueSPNEGO_shouldReplyUnauthorizedNegotiate() throws Exception {
        RequestContext req = this.buildConversationRequestContext(TEST_CONVERSATION_KEY);
        this.controller.continueSPNEGO(TEST_CONVERSATION_KEY, "Negotiate", (HttpServletRequest)req.getExternalContext().getNativeRequest(), (HttpServletResponse)req.getExternalContext().getNativeResponse());
        this.assertResponseUnauthorizedNegotiate(req);
    }

    @Test
    public void withoutSPNEGOContext_continueSPNEGO_shouldReturnAuthenticationError() throws Exception {
        RequestContext req = this.buildConversationRequestContext(TEST_CONVERSATION_KEY);
        ModelAndView mv = this.controller.continueSPNEGO(TEST_CONVERSATION_KEY, "Negotiate " + NEGOTIATE_HEADER_DATA, (HttpServletRequest)req.getExternalContext().getNativeRequest(), (HttpServletResponse)req.getExternalContext().getNativeResponse());
        this.assertAuthenticationError(req, mv, "InvalidAuthenticationContext");
    }

    @Test
    public void withoutKerberosSettings_continueSPNEGO_shouldReturnAuthenticationError() throws Exception {
        RequestContext req = this.buildConversationRequestContext(TEST_CONVERSATION_KEY);
        ModelAndView mv = this.controller.continueSPNEGO(TEST_CONVERSATION_KEY, "Negotiate " + NEGOTIATE_HEADER_DATA, (HttpServletRequest)req.getExternalContext().getNativeRequest(), (HttpServletResponse)req.getExternalContext().getNativeResponse());
        this.assertAuthenticationError(req, mv, "InvalidAuthenticationContext");
    }

    @Test
    public void givenFailedGSSContextAcceptorInstantiation_continueSPNEGO_shouldReturnAuthenticationException() throws Exception {
        final GSSException expected = new GSSException(0);
        SPNEGOAuthnController failedGSSController = new SPNEGOAuthnController(){

            @Nonnull
            protected GSSContextAcceptor createGSSContextAcceptor(@Nonnull SPNEGOContext spnegoCtx) throws GSSException {
                throw expected;
            }
        };
        RequestContext req = this.buildKerberosContextRequestContext();
        ModelAndView mv = failedGSSController.continueSPNEGO(TEST_CONVERSATION_KEY, "Negotiate " + NEGOTIATE_HEADER_DATA, (HttpServletRequest)req.getExternalContext().getNativeRequest(), (HttpServletResponse)req.getExternalContext().getNativeResponse());
        Assert.assertSame((Object)((Exception)((ServletRequest)req.getExternalContext().getNativeRequest()).getAttribute("authnException")).getCause(), (Object)expected);
        this.assertAuthenticationExceptionCause(req, mv, GSSException.class);
    }

    @Test
    public void givenSuccessfulGSSContextAcceptorInstantiation_continueSPNEGO_shouldHaveSetAcceptorInSPNEGOContext() throws Exception {
        SPNEGOContext spnegoContext;
        GSSContext mockGSSContext = (GSSContext)Mockito.mock(GSSContext.class);
        Mockito.when((Object)this.mockGSSContextAcceptor.acceptSecContext((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn((Object)"tokenBytes".getBytes());
        Mockito.when((Object)this.mockGSSContextAcceptor.getContext()).thenReturn((Object)mockGSSContext);
        Mockito.when((Object)mockGSSContext.isEstablished()).thenReturn((Object)false);
        RequestContext req = this.buildSPNEGORequestContext(NEGOTIATE_HEADER_DATA);
        this.mockedGSSController.continueSPNEGO(TEST_CONVERSATION_KEY, "Negotiate " + NEGOTIATE_HEADER_DATA, (HttpServletRequest)req.getExternalContext().getNativeRequest(), (HttpServletResponse)req.getExternalContext().getNativeResponse());
        AuthenticationContext authnContext = (AuthenticationContext)((BaseContext)req.getConversationScope().get("opensamlProfileRequestContext")).getSubcontext(AuthenticationContext.class);
        SPNEGOContext sPNEGOContext = spnegoContext = authnContext != null ? (SPNEGOContext)authnContext.getSubcontext(SPNEGOContext.class) : null;
        assert (spnegoContext != null);
        Assert.assertEquals((Object)spnegoContext.getContextAcceptor(), (Object)this.mockGSSContextAcceptor);
    }

    @Test
    public void givenHeaderAuthorizationNegotiate_withNTLMdata_continueSPNEGO_shouldReturnAuthenticationError() throws Exception {
        RequestContext req = this.buildSPNEGORequestContext(NTLMSSP_HEADER_DATA);
        ModelAndView mv = this.controller.continueSPNEGO(TEST_CONVERSATION_KEY, "Negotiate " + NTLMSSP_HEADER_DATA, (HttpServletRequest)req.getExternalContext().getNativeRequest(), (HttpServletResponse)req.getExternalContext().getNativeResponse());
        this.assertAuthenticationError(req, mv, "NTLMUnsupported");
    }

    @Test
    public void whenAcceptSecContextThrowsException_continueSPNEGO_shouldReturnAuthenticationException() throws Exception {
        RuntimeException e = new RuntimeException();
        Mockito.when((Object)this.mockGSSContextAcceptor.acceptSecContext((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenThrow(new Throwable[]{e});
        RequestContext req = this.buildSPNEGORequestContext(NEGOTIATE_HEADER_DATA);
        ModelAndView mv = this.mockedGSSController.continueSPNEGO(TEST_CONVERSATION_KEY, "Negotiate " + NEGOTIATE_HEADER_DATA, (HttpServletRequest)req.getExternalContext().getNativeRequest(), (HttpServletResponse)req.getExternalContext().getNativeResponse());
        Assert.assertSame((Object)((Exception)((HttpServletRequest)req.getExternalContext().getNativeRequest()).getAttribute("authnException")).getCause(), (Object)e);
        this.assertAuthenticationExceptionCause(req, mv, RuntimeException.class);
    }

    @Test
    public void withoutGSSContext_continueSPNEGO_shouldReturnModelAndView() throws Exception {
        Mockito.when((Object)this.mockGSSContextAcceptor.acceptSecContext((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn((Object)"tokenBytes".getBytes());
        Mockito.when((Object)this.mockGSSContextAcceptor.getContext()).thenReturn(null);
        RequestContext req = this.buildSPNEGORequestContext(NEGOTIATE_HEADER_DATA);
        ModelAndView modelAndView = this.mockedGSSController.continueSPNEGO(TEST_CONVERSATION_KEY, "", (HttpServletRequest)req.getExternalContext().getNativeRequest(), (HttpServletResponse)req.getExternalContext().getNativeResponse());
        this.assertModelAndView(modelAndView, req);
    }

    @Test
    public void withoutGSSContext_continueSPNEGO_shouldReplyUnauthorizedNegotiate() throws Exception {
        Mockito.when((Object)this.mockGSSContextAcceptor.acceptSecContext((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn((Object)"tokenBytes".getBytes());
        Mockito.when((Object)this.mockGSSContextAcceptor.getContext()).thenReturn(null);
        RequestContext req = this.buildSPNEGORequestContext(NEGOTIATE_HEADER_DATA);
        this.mockedGSSController.continueSPNEGO(TEST_CONVERSATION_KEY, "Negotiate " + NEGOTIATE_HEADER_DATA, (HttpServletRequest)req.getExternalContext().getNativeRequest(), (HttpServletResponse)req.getExternalContext().getNativeResponse());
        this.assertResponseUnauthorizedNegotiate(req, Base64Support.encode((byte[])"tokenBytes".getBytes(), (boolean)false));
    }

    @Test
    public void givenGSSContextNotEstablished_continueSPNEGO_shouldReturnModelAndView() throws Exception {
        GSSContext mockGSSContext = (GSSContext)Mockito.mock(GSSContext.class);
        Mockito.when((Object)this.mockGSSContextAcceptor.acceptSecContext((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn((Object)"tokenBytes".getBytes());
        Mockito.when((Object)this.mockGSSContextAcceptor.getContext()).thenReturn((Object)mockGSSContext);
        Mockito.when((Object)mockGSSContext.isEstablished()).thenReturn((Object)false);
        RequestContext req = this.buildSPNEGORequestContext(NEGOTIATE_HEADER_DATA);
        ModelAndView modelAndView = this.mockedGSSController.continueSPNEGO(TEST_CONVERSATION_KEY, "", (HttpServletRequest)req.getExternalContext().getNativeRequest(), (HttpServletResponse)req.getExternalContext().getNativeResponse());
        this.assertModelAndView(modelAndView, req);
    }

    @Test
    public void givenGSSContextNotEstablished_continueSPNEGO_shouldReplyUnauthorizedNegotiate() throws Exception {
        GSSContext mockGSSContext = (GSSContext)Mockito.mock(GSSContext.class);
        Mockito.when((Object)this.mockGSSContextAcceptor.acceptSecContext((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn((Object)"tokenBytes".getBytes());
        Mockito.when((Object)this.mockGSSContextAcceptor.getContext()).thenReturn((Object)mockGSSContext);
        Mockito.when((Object)mockGSSContext.isEstablished()).thenReturn((Object)false);
        RequestContext req = this.buildSPNEGORequestContext(NEGOTIATE_HEADER_DATA);
        this.mockedGSSController.continueSPNEGO(TEST_CONVERSATION_KEY, "Negotiate " + NEGOTIATE_HEADER_DATA, (HttpServletRequest)req.getExternalContext().getNativeRequest(), (HttpServletResponse)req.getExternalContext().getNativeResponse());
        this.assertResponseUnauthorizedNegotiate(req, Base64Support.encode((byte[])"tokenBytes".getBytes(), (boolean)false));
    }

    @Test
    public void givenGSSContextEstablished_andGSSException_continueSPNEGO_shouldReturnAuthenticationError() throws Exception {
        GSSContext mockGSSContext = (GSSContext)Mockito.mock(GSSContext.class);
        GSSException gssException = new GSSException(0);
        Mockito.when((Object)this.mockGSSContextAcceptor.acceptSecContext((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn((Object)"tokenBytes".getBytes());
        Mockito.when((Object)this.mockGSSContextAcceptor.getContext()).thenReturn((Object)mockGSSContext);
        Mockito.when((Object)mockGSSContext.isEstablished()).thenReturn((Object)true);
        Mockito.when((Object)mockGSSContext.getSrcName()).thenThrow(new Throwable[]{gssException});
        RequestContext req = this.buildSPNEGORequestContext(NEGOTIATE_HEADER_DATA);
        ModelAndView mv = this.mockedGSSController.continueSPNEGO(TEST_CONVERSATION_KEY, "Negotiate " + NEGOTIATE_HEADER_DATA, (HttpServletRequest)req.getExternalContext().getNativeRequest(), (HttpServletResponse)req.getExternalContext().getNativeResponse());
        Assert.assertSame((Object)((Exception)((HttpServletRequest)req.getExternalContext().getNativeRequest()).getAttribute("authnException")).getCause(), (Object)gssException);
        this.assertAuthenticationExceptionCause(req, mv, GSSException.class);
    }

    @Test
    public void givenGSSContextEstablished_continueSPNEGO_shouldReturnNull() throws Exception {
        GSSContext mockGSSContext = (GSSContext)Mockito.mock(GSSContext.class);
        GSSName mockGssName = (GSSName)Mockito.mock(GSSName.class);
        Mockito.when((Object)this.mockGSSContextAcceptor.acceptSecContext((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn((Object)"tokenBytes".getBytes());
        Mockito.when((Object)this.mockGSSContextAcceptor.getContext()).thenReturn((Object)mockGSSContext);
        Mockito.when((Object)mockGSSContext.isEstablished()).thenReturn((Object)true);
        Mockito.when((Object)mockGSSContext.getSrcName()).thenReturn((Object)mockGssName);
        Mockito.when((Object)mockGssName.toString()).thenReturn((Object)"testname@realm");
        RequestContext req = this.buildSPNEGORequestContext(NEGOTIATE_HEADER_DATA);
        Assert.assertNull((Object)this.mockedGSSController.continueSPNEGO(TEST_CONVERSATION_KEY, "Negotiate " + NEGOTIATE_HEADER_DATA, (HttpServletRequest)req.getExternalContext().getNativeRequest(), (HttpServletResponse)req.getExternalContext().getNativeResponse()));
    }

    @Test
    public void givenGSSContextEstablished_continueSPNEGO_shouldSetAuthenticationSubjectAttribute() throws Exception {
        GSSContext mockGSSContext = (GSSContext)Mockito.mock(GSSContext.class);
        GSSName mockGssName = (GSSName)Mockito.mock(GSSName.class);
        Mockito.when((Object)this.mockGSSContextAcceptor.acceptSecContext((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn((Object)"tokenBytes".getBytes());
        Mockito.when((Object)this.mockGSSContextAcceptor.getContext()).thenReturn((Object)mockGSSContext);
        Mockito.when((Object)mockGSSContext.isEstablished()).thenReturn((Object)true);
        Mockito.when((Object)mockGSSContext.getSrcName()).thenReturn((Object)mockGssName);
        Mockito.when((Object)mockGssName.toString()).thenReturn((Object)"testname@realm");
        RequestContext req = this.buildSPNEGORequestContext(NEGOTIATE_HEADER_DATA);
        this.mockedGSSController.continueSPNEGO(TEST_CONVERSATION_KEY, "Negotiate " + NEGOTIATE_HEADER_DATA, (HttpServletRequest)req.getExternalContext().getNativeRequest(), (HttpServletResponse)req.getExternalContext().getNativeResponse());
        Subject s = (Subject)((HttpServletRequest)req.getExternalContext().getNativeRequest()).getAttribute("subject");
        Assert.assertEquals(s.getClass(), Subject.class);
        Assert.assertTrue((boolean)s.getPrincipals(KerberosPrincipal.class).contains(new KerberosPrincipal("testname@realm")));
        Assert.assertTrue((boolean)s.getPrincipals(UsernamePrincipal.class).contains(new UsernamePrincipal("testname@realm")));
    }

    @Test
    public void givenGSSContextEstablishedButNoGSSNameIsNull_continueSPNEGO_shouldSetAuthenticationSubjectAttribute() throws Exception {
        GSSContext mockGSSContext = (GSSContext)Mockito.mock(GSSContext.class);
        Mockito.when((Object)this.mockGSSContextAcceptor.acceptSecContext((byte[])ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt())).thenReturn((Object)"tokenBytes".getBytes());
        Mockito.when((Object)this.mockGSSContextAcceptor.getContext()).thenReturn((Object)mockGSSContext);
        Mockito.when((Object)mockGSSContext.isEstablished()).thenReturn((Object)true);
        Mockito.when((Object)mockGSSContext.getSrcName()).thenReturn(null);
        RequestContext req = this.buildSPNEGORequestContext(NEGOTIATE_HEADER_DATA);
        ModelAndView mv = this.mockedGSSController.continueSPNEGO(TEST_CONVERSATION_KEY, "Negotiate " + NEGOTIATE_HEADER_DATA, (HttpServletRequest)req.getExternalContext().getNativeRequest(), (HttpServletResponse)req.getExternalContext().getNativeResponse());
        Assert.assertNull((Object)mv);
        Assert.assertEquals(((HttpServletRequest)req.getExternalContext().getNativeRequest()).getAttribute("authnException").getClass(), ExternalAuthenticationException.class);
    }

    private RequestContext buildSPNEGORequestContext(String negotiateHeaderData) throws ComponentInitializationException {
        RequestContext req = this.buildKerberosContextRequestContext();
        ((MockHttpServletRequest)req.getExternalContext().getNativeRequest()).addHeader("Authorization", (Object)("Negotiate " + negotiateHeaderData));
        return req;
    }

    private RequestContext buildKerberosContextRequestContext() throws ComponentInitializationException {
        RequestContext req = this.buildConversationRequestContext(TEST_CONVERSATION_KEY);
        this.buildKerberosProfileRequestContext(req);
        return req;
    }

    private ProfileRequestContext buildKerberosProfileRequestContext(RequestContext rc) {
        ProfileRequestContext prc = (ProfileRequestContext)rc.getConversationScope().get("opensamlProfileRequestContext");
        AuthenticationContext ac = (AuthenticationContext)prc.getSubcontext(AuthenticationContext.class);
        SPNEGOContext sc = new SPNEGOContext();
        KerberosSettings ks = new KerberosSettings();
        ArrayList<KerberosRealmSettings> realms = new ArrayList<KerberosRealmSettings>();
        realms.add(new KerberosRealmSettings());
        ks.setRealms(realms);
        sc.setKerberosSettings(ks);
        assert (ac != null);
        ac.addSubcontext((BaseContext)sc);
        return prc;
    }

    private RequestContext buildConversationRequestContext(String conversationKey) throws ComponentInitializationException {
        RequestContext rc = new RequestContextBuilder().buildRequestContext();
        if (conversationKey != null) {
            ((MockHttpServletRequest)rc.getExternalContext().getNativeRequest()).addParameter("conversation", conversationKey);
        }
        ProfileRequestContext prc = (ProfileRequestContext)rc.getConversationScope().get("opensamlProfileRequestContext");
        ((MockServletContext)rc.getExternalContext().getNativeContext()).setAttribute("net.shibboleth.idp.flowExecutor", (Object)prc);
        AuthenticationContext ac = (AuthenticationContext)prc.ensureSubcontext(AuthenticationContext.class);
        assert (ac != null);
        ac.setAttemptedFlow(new AuthenticationFlowDescriptor());
        ExternalAuthenticationContext eac = (ExternalAuthenticationContext)ac.addSubcontext((BaseContext)new ExternalAuthenticationContext((ExternalAuthentication)new ExternalAuthenticationImpl()));
        eac.setFlowExecutionUrl("foo");
        return rc;
    }

    private void assertAuthenticationError(RequestContext request, ModelAndView mv, String expectedError) {
        Assert.assertNull((Object)mv);
        Assert.assertEquals((String)((ServletRequest)request.getExternalContext().getNativeRequest()).getAttribute("authnError").toString(), (String)expectedError);
    }

    private void assertAuthenticationExceptionCause(RequestContext request, ModelAndView mv, Class<?> exceptedExceptionClass) {
        Assert.assertNull((Object)mv);
        Assert.assertEquals(((Exception)((ServletRequest)request.getExternalContext().getNativeRequest()).getAttribute("authnException")).getCause().getClass(), exceptedExceptionClass);
    }

    private void assertModelAndView(ModelAndView modelAndView, RequestContext request) {
        Assert.assertEquals((String)modelAndView.getViewName(), (String)"spnego-unavailable");
        Map model = modelAndView.getModel();
        Assert.assertTrue((boolean)model.containsKey("encoder"), (String)"Model doesn't contain \"encoder\"");
        Assert.assertEquals(model.get("encoder").getClass(), Class.class);
        Assert.assertTrue((boolean)model.containsKey("errorUrl"), (String)"Model doesn't contain \"errorUrl\"");
        Assert.assertEquals(model.get("errorUrl").getClass(), String.class);
        if (((HttpServletRequest)request.getExternalContext().getNativeRequest()).getQueryString() != null) {
            Assert.assertTrue((boolean)((String)model.get("errorUrl")).endsWith("/error?" + ((HttpServletRequest)request.getExternalContext().getNativeRequest()).getQueryString()));
        } else {
            Assert.assertTrue((boolean)((String)model.get("errorUrl")).endsWith("/error"));
        }
        Assert.assertTrue((boolean)model.containsKey("request"), (String)"Model doesn't contain \"request\"");
        Assert.assertTrue((boolean)(model.get("request") instanceof HttpServletRequest));
    }

    private void assertResponseUnauthorizedNegotiate(RequestContext request) {
        HttpServletResponse response = (HttpServletResponse)request.getExternalContext().getNativeResponse();
        Assert.assertEquals((int)response.getStatus(), (int)401);
        Assert.assertEquals((String)response.getHeader("WWW-Authenticate"), (String)"Negotiate");
    }

    private void assertResponseUnauthorizedNegotiate(RequestContext request, String base64token) {
        HttpServletResponse response = (HttpServletResponse)request.getExternalContext().getNativeResponse();
        Assert.assertEquals((int)response.getStatus(), (int)401);
        Assert.assertEquals((String)response.getHeader("WWW-Authenticate"), (String)("Negotiate " + base64token));
    }
}

