/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.spnego.impl;

import jakarta.servlet.http.Cookie;
import net.shibboleth.idp.authn.spnego.impl.SPNEGOAutoLoginManager;
import net.shibboleth.shared.net.CookieManager;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.testing.ConstantSupplier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SPNEGOAutoLoginManagerTest {
    protected static final String AUTOLOGIN_COOKIE_VALUE_FALSE = "false";
    protected static final String AUTOLOGIN_COOKIE_VALUE_OTHER = "other";

    @BeforeMethod
    public void setUp() throws Exception {
    }

    protected SPNEGOAutoLoginManager createAutoLoginManager(MockHttpServletRequest req, MockHttpServletResponse res) throws Exception {
        CookieManager cookieManager = new CookieManager();
        MockHttpServletRequest request = req != null ? req : new MockHttpServletRequest();
        MockHttpServletResponse response = res != null ? res : new MockHttpServletResponse();
        cookieManager.setHttpServletRequestSupplier((NonnullSupplier)new ConstantSupplier((Object)request));
        cookieManager.setHttpServletResponseSupplier((NonnullSupplier)new ConstantSupplier((Object)response));
        cookieManager.initialize();
        SPNEGOAutoLoginManager autoLoginManager = new SPNEGOAutoLoginManager();
        autoLoginManager.setCookieManager(cookieManager);
        autoLoginManager.setCookieName("spnego_autologin");
        autoLoginManager.initialize();
        return autoLoginManager;
    }

    @Test
    public void enableAutoLogin_shouldSetCookieToTrue() throws Exception {
        MockHttpServletResponse res = new MockHttpServletResponse();
        SPNEGOAutoLoginManager autoLoginManager = this.createAutoLoginManager(null, res);
        autoLoginManager.enable();
        Cookie cookie = res.getCookie("spnego_autologin");
        assert (cookie != null);
        Assert.assertEquals((String)cookie.getValue(), (String)"1");
    }

    @Test
    public void disableAutoLogin_shouldUnsetCookie() throws Exception {
        MockHttpServletResponse res = new MockHttpServletResponse();
        SPNEGOAutoLoginManager autoLoginManager = this.createAutoLoginManager(null, res);
        autoLoginManager.disable();
        Cookie cookie = res.getCookie("spnego_autologin");
        assert (cookie != null);
        Assert.assertNull((Object)cookie.getValue());
    }

    @Test
    public void givenCookieTrue_onlyIsEnabledShouldReturnTrue() throws Exception {
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setCookies(new Cookie[]{new Cookie("spnego_autologin", "1")});
        SPNEGOAutoLoginManager autoLoginManager = this.createAutoLoginManager(req, null);
        Assert.assertTrue((boolean)autoLoginManager.isEnabled());
        Assert.assertFalse((boolean)autoLoginManager.isDisabled());
    }

    @Test
    public void givenCookieAbsent_onlyIsDisabledShouldReturnTrue() throws Exception {
        MockHttpServletRequest req = new MockHttpServletRequest();
        SPNEGOAutoLoginManager autoLoginManager = this.createAutoLoginManager(req, null);
        Assert.assertFalse((boolean)autoLoginManager.isEnabled());
        Assert.assertTrue((boolean)autoLoginManager.isDisabled());
    }

    @Test
    public void givenCookieFalse_onlyIsDisabledShouldReturnTrue() throws Exception {
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setCookies(new Cookie[]{new Cookie("spnego_autologin", AUTOLOGIN_COOKIE_VALUE_FALSE)});
        SPNEGOAutoLoginManager autoLoginManager = this.createAutoLoginManager(req, null);
        Assert.assertFalse((boolean)autoLoginManager.isEnabled());
        Assert.assertTrue((boolean)autoLoginManager.isDisabled());
    }

    @Test
    public void givenCookieOtherValue_onlyIsDisabledShouldReturnTrue() throws Exception {
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setCookies(new Cookie[]{new Cookie("spnego_autologin", AUTOLOGIN_COOKIE_VALUE_OTHER)});
        SPNEGOAutoLoginManager autoLoginManager = this.createAutoLoginManager(req, null);
        Assert.assertFalse((boolean)autoLoginManager.isEnabled());
        Assert.assertTrue((boolean)autoLoginManager.isDisabled());
    }
}

