/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.tests;

import net.shibboleth.idp.authn.SubjectCanonicalizationFlowDescriptor;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.component.UnmodifiableComponentException;
import net.shibboleth.shared.logic.PredicateSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SubjectCanonicalizationFlowDescriptorTest {
    private SubjectCanonicalizationFlowDescriptor descriptor;
    private RequestContext src;
    private ProfileRequestContext prc;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.descriptor = new SubjectCanonicalizationFlowDescriptor();
        this.descriptor.setId("test");
        this.descriptor.initialize();
        this.src = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.src);
    }

    @Test
    public void testInstantation() throws ComponentInitializationException {
        Assert.assertEquals((String)this.descriptor.getId(), (String)"test");
        Assert.assertTrue((boolean)this.descriptor.test(this.prc));
    }

    @Test
    public void testSetters() {
        try {
            this.descriptor.setActivationCondition(PredicateSupport.alwaysFalse());
            Assert.fail();
        }
        catch (UnmodifiableComponentException unmodifiableComponentException) {
            // empty catch block
        }
    }

    @Test
    public void testEquality() {
        SubjectCanonicalizationFlowDescriptor sameId = new SubjectCanonicalizationFlowDescriptor();
        sameId.setId("test");
        Assert.assertTrue((boolean)this.descriptor.equals((Object)sameId));
        SubjectCanonicalizationFlowDescriptor differentId = new SubjectCanonicalizationFlowDescriptor();
        differentId.setId("differentId");
        Assert.assertFalse((boolean)this.descriptor.equals((Object)differentId));
    }

    @Test
    public void testPredicate() throws ComponentInitializationException {
        this.descriptor = new SubjectCanonicalizationFlowDescriptor();
        this.descriptor.setId("test");
        this.descriptor.setActivationCondition(PredicateSupport.alwaysFalse());
        this.descriptor.initialize();
        Assert.assertFalse((boolean)this.descriptor.test(this.prc));
    }
}

