/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractValidationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.AuthenticationErrorContext;
import net.shibboleth.idp.profile.audit.impl.PopulateAuditContext;
import net.shibboleth.idp.profile.audit.impl.WriteAuditLog;
import net.shibboleth.profile.context.AuditContext;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public abstract class AbstractAuditingValidationAction
extends AbstractValidationAction {
    @Nonnull
    private Function<ProfileRequestContext, AuditContext> auditContextCreationStrategy = new ChildContextLookup(AuditContext.class, true).compose((Function)new ChildContextLookup(AuthenticationContext.class));
    @Nullable
    private PopulateAuditContext populateAuditContextAction;
    @Nullable
    private WriteAuditLog writeAuditLogAction;
    @Nullable
    private RequestContext requestContext;

    public void setAuditContextCreationStrategy(@Nonnull Function<ProfileRequestContext, AuditContext> strategy) {
        this.checkSetterPreconditions();
        this.auditContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuditContext creation strategy cannot be null");
    }

    public void setPopulateAuditContextAction(@Nullable PopulateAuditContext action) {
        this.checkSetterPreconditions();
        this.populateAuditContextAction = action;
    }

    public void setWriteAuditLogAction(@Nullable WriteAuditLog action) {
        this.checkSetterPreconditions();
        this.writeAuditLogAction = action;
    }

    protected Event doExecute(@Nonnull RequestContext springRequestContext, @Nonnull ProfileRequestContext profileRequestContext) {
        this.requestContext = springRequestContext;
        return super.doExecute(springRequestContext, profileRequestContext);
    }

    protected void recordSuccess(@Nonnull ProfileRequestContext profileRequestContext) {
        this.doAudit(profileRequestContext, true);
        super.recordSuccess(profileRequestContext);
    }

    protected void recordFailure(@Nonnull ProfileRequestContext profileRequestContext) {
        this.doAudit(profileRequestContext, false);
        super.recordFailure(profileRequestContext);
    }

    @Nullable
    protected AuditContext getAuditContext(@Nonnull ProfileRequestContext profileRequestContext) {
        return this.auditContextCreationStrategy.apply(profileRequestContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAudit(@Nonnull ProfileRequestContext profileRequestContext, boolean success) {
        if (this.populateAuditContextAction != null && this.writeAuditLogAction != null) {
            EventContext existingEvent = (EventContext)profileRequestContext.getSubcontext(EventContext.class);
            try {
                assert (this.populateAuditContextAction != null);
                this.populateAuditContextAction.execute(this.requestContext);
                AuditContext ac = this.getAuditContext(profileRequestContext);
                if (ac != null) {
                    Map<String, String> fields = this.getAuditFields(profileRequestContext);
                    if (fields != null) {
                        for (Map.Entry<String, String> field : fields.entrySet()) {
                            String key = field.getKey();
                            assert (key != null);
                            ac.getFieldValues(key).add(field.getValue());
                        }
                    }
                    if (success) {
                        ac.getFields().put((Object)"AR", (Object)"Success");
                    } else {
                        AuthenticationErrorContext errorContext = (AuthenticationErrorContext)((AuthenticationContext)profileRequestContext.ensureSubcontext(AuthenticationContext.class)).getSubcontext(AuthenticationErrorContext.class);
                        if (errorContext != null) {
                            ac.getFields().put((Object)"AR", (Object)errorContext.getLastClassifiedError());
                        }
                    }
                }
            }
            finally {
                if (existingEvent != null) {
                    profileRequestContext.addSubcontext((BaseContext)existingEvent);
                }
            }
            try {
                assert (this.writeAuditLogAction != null);
                this.writeAuditLogAction.execute(this.requestContext);
            }
            finally {
                if (existingEvent != null) {
                    profileRequestContext.addSubcontext((BaseContext)existingEvent);
                }
            }
        }
    }

    @Nullable
    @Unmodifiable
    @NotLive
    protected Map<String, String> getAuditFields(@Nonnull ProfileRequestContext profileRequestContext) {
        return null;
    }
}

