/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import jakarta.servlet.http.HttpServletRequest;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.AbstractExtractionAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ExtractUsernamePasswordFromFormRequest
extends AbstractExtractionAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExtractUsernamePasswordFromFormRequest.class);
    @Nonnull
    @NotEmpty
    private String usernameFieldName = "username";
    @Nonnull
    @NotEmpty
    private String passwordFieldName = "password";
    @Nonnull
    @NotEmpty
    private String ssoBypassFieldName = "donotcache";

    ExtractUsernamePasswordFromFormRequest() {
    }

    public void setUsernameFieldName(@Nonnull @NotEmpty String fieldName) {
        this.checkSetterPreconditions();
        this.usernameFieldName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)fieldName), (String)"Username field name cannot be null or empty.");
    }

    public void setPasswordFieldName(@Nonnull @NotEmpty String fieldName) {
        this.checkSetterPreconditions();
        this.passwordFieldName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)fieldName), (String)"Password field name cannot be null or empty.");
    }

    public void setSSOBypassFieldName(@Nonnull @NotEmpty String fieldName) {
        this.checkSetterPreconditions();
        this.ssoBypassFieldName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)fieldName), (String)"SSO Bypass field name cannot be null or empty.");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        UsernamePasswordContext upCtx = (UsernamePasswordContext)authenticationContext.ensureSubcontext(UsernamePasswordContext.class);
        upCtx.setUsername(null);
        upCtx.setPassword(null);
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            this.log.debug("{} Profile action does not contain an HttpServletRequest", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        String username = request.getParameter(this.usernameFieldName);
        if (username == null || username.isEmpty()) {
            this.log.debug("{} No username in request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        upCtx.setUsername(this.applyTransforms(username));
        String password = request.getParameter(this.passwordFieldName);
        if (password == null || password.isEmpty()) {
            this.log.debug("{} No password in request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        upCtx.setPassword(password);
        String donotcache = request.getParameter(this.ssoBypassFieldName);
        if (donotcache != null && "1".equals(donotcache)) {
            this.log.debug("{} Recording do-not-cache instruction in authentication context", (Object)this.getLogPrefix());
            authenticationContext.setResultCacheable(false);
        }
    }
}

