/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.Principal;
import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UsernameContext;
import net.shibboleth.idp.authn.impl.AbstractAuditingValidationAction;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateRemoteUser
extends AbstractAuditingValidationAction {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.authn.remoteuser";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateRemoteUser.class);
    @Nonnull
    private Set<String> allowedUsernames = CollectionSupport.emptySet();
    @Nonnull
    private Set<String> deniedUsernames = CollectionSupport.emptySet();
    @Nullable
    private Pattern matchExpression;
    @NonnullBeforeExec
    private UsernameContext usernameContext;

    public ValidateRemoteUser() {
        this.setMetricName(DEFAULT_METRIC_NAME);
    }

    public void setAllowedUsernames(@Nullable Collection<String> allowed) {
        this.checkSetterPreconditions();
        this.allowedUsernames = CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection(allowed));
    }

    public void setDeniedUsernames(@Nullable Collection<String> denied) {
        this.checkSetterPreconditions();
        this.deniedUsernames = CollectionSupport.copyToSet((Collection)StringSupport.normalizeStringCollection(denied));
    }

    public void setMatchExpression(@Nullable Pattern expression) {
        this.checkSetterPreconditions();
        this.matchExpression = expression != null && !expression.pattern().isEmpty() ? expression : null;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        this.usernameContext = (UsernameContext)authenticationContext.getSubcontext(UsernameContext.class);
        if (this.usernameContext == null) {
            this.log.debug("{} No UsernameContext available within authentication context", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            return false;
        }
        if (this.usernameContext.getUsername() == null) {
            this.log.debug("{} No username available within UsernameContext", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        String userName = this.usernameContext.getUsername();
        assert (userName != null);
        if (!this.isAuthenticated(userName)) {
            this.log.info("{} User '{}' was not valid", (Object)this.getLogPrefix(), (Object)userName);
            this.handleError(profileRequestContext, authenticationContext, "InvalidCredentials", "InvalidCredentials");
            this.recordFailure(profileRequestContext);
            return;
        }
        this.log.info("{} Validated user '{}'", (Object)this.getLogPrefix(), (Object)userName);
        this.recordSuccess(profileRequestContext);
        this.buildAuthenticationResult(profileRequestContext, authenticationContext);
    }

    private boolean isAuthenticated(@Nonnull @NotEmpty String username) {
        Pattern mc = this.matchExpression;
        if (!this.allowedUsernames.isEmpty() && !this.allowedUsernames.contains(username)) {
            if (mc == null) {
                return false;
            }
            return mc.matcher(username).matches();
        }
        return !this.deniedUsernames.contains(username) && (mc == null || mc.matcher(username).matches());
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject) {
        String userName = this.usernameContext.getUsername();
        assert (userName != null);
        subject.getPrincipals().add((Principal)new UsernamePrincipal(userName));
        return subject;
    }
}

