/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal.impl;

import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.Principal;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.principal.AbstractPrincipalSerializer;
import net.shibboleth.idp.authn.principal.AuthenticationResultPrincipal;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.storage.StorageSerializer;
import org.slf4j.Logger;

@ThreadSafe
public class AuthenticationResultPrincipalSerializer
extends AbstractPrincipalSerializer<String> {
    @Nonnull
    @NotEmpty
    private static final String PRINCIPAL_NAME_FIELD = "AUTHRES";
    private static final Pattern JSON_PATTERN = Pattern.compile("^\\{\"AUTHRES\":.*\\}$");
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AuthenticationResultPrincipalSerializer.class);
    @Nonnull
    private final StorageSerializer<AuthenticationResult> resultSerializer;

    public AuthenticationResultPrincipalSerializer(@Nonnull StorageSerializer<AuthenticationResult> serializer) {
        this.resultSerializer = (StorageSerializer)Constraint.isNotNull(serializer, (String)"AuthenticationResult serializer cannot be null");
    }

    public boolean supports(@Nonnull Principal principal) {
        return principal instanceof AuthenticationResultPrincipal;
    }

    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull Principal principal) throws IOException {
        StringWriter sink = new StringWriter(128);
        try (JsonGenerator gen = this.getJsonGenerator(sink);){
            gen.writeStartObject();
            AuthenticationResult result = ((AuthenticationResultPrincipal)principal).getAuthenticationResult();
            gen.write(PRINCIPAL_NAME_FIELD, this.resultSerializer.serialize((Object)result));
            gen.writeEnd();
        }
        String result = sink.toString();
        assert (result != null);
        return result;
    }

    public boolean supports(@Nonnull @NotEmpty String value) {
        return JSON_PATTERN.matcher(value).matches();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public AuthenticationResultPrincipal deserialize(@Nonnull @NotEmpty String value) throws IOException {
        try (JsonReader reader = this.getJsonReader(new StringReader(value));){
            JsonStructure st = reader.read();
            if (!(st instanceof JsonObject)) {
                throw new IOException("Found invalid data structure while parsing AuthenticationResultPrincipal");
            }
            JsonObject obj = (JsonObject)st;
            JsonValue str = (JsonValue)obj.get((Object)PRINCIPAL_NAME_FIELD);
            if (str != null && str instanceof JsonString) {
                String nativeString = ((JsonString)str).getString();
                assert (nativeString != null);
                AuthenticationResultPrincipal authenticationResultPrincipal2 = new AuthenticationResultPrincipal((AuthenticationResult)this.resultSerializer.deserialize(1L, "context", "key", nativeString, null));
                return authenticationResultPrincipal2;
            }
            this.log.warn("Skipping non-string principal value");
            AuthenticationResultPrincipal authenticationResultPrincipal = null;
            return authenticationResultPrincipal;
        }
        catch (JsonException e) {
            throw new IOException("Found invalid data structure while parsing AuthenticationResultPrincipal", e);
        }
    }
}

