/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.principal.impl;

import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.Principal;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import javax.security.auth.x500.X500Principal;
import net.shibboleth.idp.authn.principal.AbstractPrincipalSerializer;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.codec.EncodingException;

@ThreadSafe
public class X500PrincipalSerializer
extends AbstractPrincipalSerializer<String> {
    @Nonnull
    @NotEmpty
    private static final String X500_NAME_FIELD = "X500";
    private static final Pattern JSON_PATTERN = Pattern.compile("^\\{\"X500\":.*\\}$");

    public boolean supports(@Nonnull Principal principal) {
        return principal instanceof X500Principal;
    }

    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull Principal principal) throws IOException {
        String name;
        X500Principal x500Principal = (X500Principal)principal;
        try {
            byte[] encoded = x500Principal.getEncoded();
            assert (encoded != null);
            name = Base64Support.encode((byte[])encoded, (boolean)false);
        }
        catch (EncodingException e) {
            throw new IOException(e);
        }
        StringWriter sink = new StringWriter(32);
        try (JsonGenerator gen = this.getJsonGenerator(sink);){
            gen.writeStartObject().write(X500_NAME_FIELD, name).writeEnd();
        }
        String result = sink.toString();
        assert (result != null);
        return result;
    }

    public boolean supports(@Nonnull @NotEmpty String value) {
        return JSON_PATTERN.matcher(value).matches();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public X500Principal deserialize(@Nonnull @NotEmpty String value) throws IOException {
        try (JsonReader reader = this.getJsonReader(new StringReader(value));){
            JsonStructure st = reader.read();
            if (!(st instanceof JsonObject)) {
                throw new IOException("Found invalid data structure while parsing X500Principal");
            }
            JsonValue jsonValue = (JsonValue)((JsonObject)st).get((Object)X500_NAME_FIELD);
            if (jsonValue == null) throw new IOException("Serialized X500Principal missing name field");
            if (!JsonValue.ValueType.STRING.equals((Object)jsonValue.getValueType())) throw new IOException("Serialized X500Principal missing name field");
            String nativeString = ((JsonString)jsonValue).getString();
            assert (nativeString != null);
            X500Principal x500Principal = new X500Principal(Base64Support.decode((String)nativeString));
            return x500Principal;
        }
        catch (JsonException | IllegalArgumentException | DecodingException e) {
            throw new IOException("Found invalid data while parsing X500Principal", e);
        }
    }
}

