/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.proxy.impl;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import jakarta.servlet.http.HttpServletRequest;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;

@ThreadSafe
public class DiscoveryProfileRequestFunction
extends AbstractInitializableComponent
implements BiFunction<RequestContext, ProfileRequestContext, String> {
    @Nonnull
    private Escaper escaper;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy;
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> discoveryURLLookupStrategy;
    @Nullable
    private BiFunction<RequestContext, ProfileRequestContext, String> delegatedRequestFunction;

    public DiscoveryProfileRequestFunction() {
        Escaper esc = UrlEscapers.urlFormParameterEscaper();
        assert (esc != null);
        this.escaper = esc;
        this.relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setDiscoveryURLLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.discoveryURLLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Discovery URL lookup strategy cannot be null");
    }

    public void setDelegatedRequestFunction(@Nullable BiFunction<RequestContext, ProfileRequestContext, String> delegate) {
        this.checkSetterPreconditions();
        this.delegatedRequestFunction = delegate;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.discoveryURLLookupStrategy == null) {
            throw new ComponentInitializationException("Discovery URL lookup strategy cannot be null");
        }
    }

    @Override
    @Nullable
    public String apply(@Nullable RequestContext springRequestContext, @Nullable ProfileRequestContext profileRequestContext) {
        AuthenticationContext authenticationContext;
        if (this.delegatedRequestFunction != null) {
            return this.delegatedRequestFunction.apply(springRequestContext, profileRequestContext);
        }
        if (springRequestContext == null) {
            throw new IllegalArgumentException("Spring RequestContext cannot be null");
        }
        RelyingPartyContext rpCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        Constraint.isNotNull((Object)rpCtx, (String)"RelyingPartyContext cannot be null");
        Constraint.isNotNull((Object)rpCtx.getConfiguration(), (String)"RelyingPartyConfiguration cannot be null");
        String baseURL = this.discoveryURLLookupStrategy.apply(profileRequestContext);
        Constraint.isNotEmpty((String)baseURL, (String)"Discovery URL cannot be null or empty");
        RelyingPartyConfiguration rpConfig = rpCtx.getConfiguration();
        assert (rpConfig != null);
        String entityID = rpConfig.getIssuer(profileRequestContext);
        StringBuilder builder = new StringBuilder(baseURL);
        builder.append(baseURL.contains("?") ? (char)'&' : '?').append("entityID=").append(this.escaper.escape(entityID));
        AuthenticationContext authenticationContext2 = authenticationContext = profileRequestContext != null ? (AuthenticationContext)profileRequestContext.getSubcontext(AuthenticationContext.class) : null;
        if (authenticationContext != null && authenticationContext.isPassive()) {
            builder.append("&isPassive=true");
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)springRequestContext.getExternalContext().getNativeRequest();
        StringBuilder selfBuilder = new StringBuilder(httpServletRequest.getScheme());
        selfBuilder.append("://").append(httpServletRequest.getServerName());
        int port = httpServletRequest.getServerPort();
        if (port != (httpServletRequest.isSecure() ? 443 : 80)) {
            selfBuilder.append(':').append(port);
        }
        selfBuilder.append(springRequestContext.getFlowExecutionUrl()).append("&_eventId_proceed=1");
        builder.append("&return=").append(this.escaper.escape(selfBuilder.toString()));
        return builder.toString();
    }
}

