/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import com.google.common.base.Charsets;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractExtractionAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.DecodingException;
import net.shibboleth.shared.collection.Pair;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ExtractUsernamePasswordFromBasicAuth
extends AbstractExtractionAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExtractUsernamePasswordFromBasicAuth.class);
    @Nonnull
    private Function<ProfileRequestContext, UsernamePasswordContext> contextCreationStrategy = new ChildContextLookup(UsernamePasswordContext.class, true).compose((Function)new ChildContextLookup(AuthenticationContext.class));

    public void setUsernamePasswordContextCreationStrategy(@Nonnull Function<ProfileRequestContext, UsernamePasswordContext> strategy) {
        this.checkSetterPreconditions();
        this.contextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"UsernamePasswordContext creation strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        UsernamePasswordContext upCtx = this.contextCreationStrategy.apply(profileRequestContext);
        upCtx.setUsername(null);
        upCtx.setPassword(null);
        HttpServletRequest request = this.getHttpServletRequest();
        if (request == null) {
            this.log.debug("{} Profile action does not contain an HttpServletRequest", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        String encodedCredentials = this.extractCredentials(request);
        if (encodedCredentials == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        Pair<String, String> decodedCredentials = this.decodeCredentials(encodedCredentials);
        if (decodedCredentials == null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidCredentials");
            return;
        }
        upCtx.setUsername(this.applyTransforms(profileRequestContext, (String)decodedCredentials.getFirst())).setPassword((String)decodedCredentials.getSecond());
    }

    @Nullable
    protected String extractCredentials(@Nonnull HttpServletRequest httpRequest) {
        Enumeration header = httpRequest.getHeaders("Authorization");
        while (header.hasMoreElements()) {
            String authnScheme;
            String[] splitValue = ((String)header.nextElement()).split(" ");
            if (splitValue.length != 2 || !"BASIC".equalsIgnoreCase(authnScheme = StringSupport.trimOrNull((String)splitValue[0]))) continue;
            return StringSupport.trimOrNull((String)splitValue[1]);
        }
        this.log.debug("{} No appropriate Authorization header found", (Object)this.getLogPrefix());
        return null;
    }

    @Nullable
    protected Pair<String, String> decodeCredentials(@Nonnull @NotEmpty String encodedCredentials) {
        String password;
        String username;
        String decodedUserPass = null;
        try {
            decodedUserPass = new String(Base64Support.decode((String)encodedCredentials), Charsets.UTF_8);
        }
        catch (DecodingException e) {
            this.log.warn("{} Credentials could not be base64 decoded: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
        }
        if (decodedUserPass != null && decodedUserPass.contains(":") && (username = decodedUserPass.substring(0, decodedUserPass.indexOf(58))) != null && decodedUserPass.length() > username.length() + 1 && (password = decodedUserPass.substring(decodedUserPass.indexOf(58) + 1)) != null) {
            return new Pair((Object)username, (Object)password);
        }
        this.log.debug("{} Request did not contain a well-formed Basic authorization header value", (Object)this.getLogPrefix());
        return null;
    }
}

