/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.Principal;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AbstractUsernamePasswordCredentialValidator;
import net.shibboleth.idp.authn.CredentialValidator;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.context.LDAPResponseContext;
import net.shibboleth.idp.authn.context.UsernamePasswordContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.velocity.VelocityContext;
import org.ldaptive.Credential;
import org.ldaptive.LdapException;
import org.ldaptive.ResultCode;
import org.ldaptive.auth.AccountState;
import org.ldaptive.auth.AuthenticationRequest;
import org.ldaptive.auth.AuthenticationResponse;
import org.ldaptive.auth.AuthenticationResultCode;
import org.ldaptive.auth.Authenticator;
import org.ldaptive.auth.User;
import org.ldaptive.jaas.LdapPrincipal;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public class LDAPCredentialValidator
extends AbstractUsernamePasswordCredentialValidator {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(LDAPCredentialValidator.class);
    @NonnullAfterInit
    private Authenticator authenticator;
    @Nullable
    private String[] returnAttributes;
    @Nullable
    private Function<ProfileRequestContext, char[]> passwordLookupStrategy;

    @NonnullAfterInit
    public Authenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setAuthenticator(@Nonnull Authenticator auth) {
        this.checkSetterPreconditions();
        this.authenticator = (Authenticator)Constraint.isNotNull((Object)auth, (String)"Authenticator cannot be null");
    }

    @Nullable
    public String[] getReturnAttributes() {
        return this.returnAttributes;
    }

    public void setReturnAttributes(String ... attributes) {
        this.checkSetterPreconditions();
        this.returnAttributes = attributes;
    }

    public void setPasswordLookupStrategy(@Nullable Function<ProfileRequestContext, char[]> strategy) {
        this.checkSetterPreconditions();
        this.passwordLookupStrategy = strategy;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.authenticator == null) {
            throw new ComponentInitializationException("Authenticator cannot be null");
        }
    }

    protected void doDestroy() {
        super.doDestroy();
    }

    @Nullable
    protected Subject doValidate(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext, @Nonnull UsernamePasswordContext usernamePasswordContext, @Nullable CredentialValidator.WarningHandler warningHandler, @Nullable CredentialValidator.ErrorHandler errorHandler) throws Exception {
        LdapException authException;
        String eventToSignal;
        AuthenticationResponse response;
        char[] password;
        String username = usernamePasswordContext.getTransformedUsername();
        this.log.debug("{} Attempting to authenticate user {}", (Object)this.getLogPrefix(), (Object)username);
        VelocityContext context = new VelocityContext();
        context.put("usernamePasswordContext", (Object)usernamePasswordContext);
        if (this.passwordLookupStrategy != null) {
            password = this.passwordLookupStrategy.apply(profileRequestContext);
        } else {
            String ctxPassword = usernamePasswordContext.getPassword();
            assert (ctxPassword != null);
            password = ctxPassword.toCharArray();
        }
        AuthenticationRequest request = new AuthenticationRequest(new User(username, (Object)context), new Credential(password), this.returnAttributes);
        try {
            response = this.authenticator.authenticate(request);
        }
        catch (LdapException e) {
            this.log.error("{} Error attempting LDAP authentication for '{}'", new Object[]{this.getLogPrefix(), username, e});
            if (errorHandler != null) {
                errorHandler.handleError(profileRequestContext, authenticationContext, (Exception)((Object)e), "AuthenticationException");
            }
            throw e;
        }
        this.log.debug("{} Authentication response {}", (Object)this.getLogPrefix(), (Object)response);
        ((LDAPResponseContext)authenticationContext.ensureSubcontext(LDAPResponseContext.class)).setAuthenticationResponse(response);
        if (response.isSuccess()) {
            this.log.info("{} Login by '{}' succeeded", (Object)this.getLogPrefix(), (Object)username);
            if (response.getAccountState() != null) {
                AccountState.Error error = response.getAccountState().getError();
                if (warningHandler != null) {
                    warningHandler.handleWarning(profileRequestContext, authenticationContext, String.format("%s:%s:%s", error != null ? error : "ACCOUNT_WARNING", response.getResultCode(), response.getDiagnosticMessage()), "AccountWarning");
                }
            }
            return this.populateSubject(usernamePasswordContext, response);
        }
        if (AuthenticationResultCode.DN_RESOLUTION_FAILURE == response.getAuthenticationResultCode() || AuthenticationResultCode.INVALID_CREDENTIAL == response.getAuthenticationResultCode()) {
            eventToSignal = "InvalidCredentials";
            authException = new LdapException(String.format("%s:%s", response.getAuthenticationResultCode(), response.getDiagnosticMessage()));
        } else if (response.getAccountState() != null) {
            AccountState state = response.getAccountState();
            eventToSignal = "AccountError";
            authException = new LdapException(response.getResultCode(), String.format("%s:%s:%s", state.getError(), response.getResultCode(), response.getDiagnosticMessage()));
        } else if (response.getResultCode() == ResultCode.INVALID_CREDENTIALS) {
            eventToSignal = "InvalidCredentials";
            authException = new LdapException(response.getResultCode(), String.format("%s:%s", response.getResultCode(), response.getDiagnosticMessage()));
        } else {
            eventToSignal = "AuthenticationException";
            authException = new LdapException(response.getResultCode(), String.format("%s:%s", response.getResultCode(), response.getDiagnosticMessage()));
        }
        this.log.info("{} Login by '{}' failed", new Object[]{this.getLogPrefix(), username, authException});
        if (errorHandler != null) {
            errorHandler.handleError(profileRequestContext, authenticationContext, (Exception)((Object)authException), eventToSignal);
        }
        throw authException;
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull UsernamePasswordContext usernamePasswordContext, @Nonnull AuthenticationResponse ldapResponse) {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new LdapPrincipal(usernamePasswordContext.getTransformedUsername(), ldapResponse.getLdapEntry()));
        return super.populateSubject(subject, usernamePasswordContext);
    }
}

