/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.AuthenticationFlowDescriptor;
import net.shibboleth.idp.authn.config.navigate.AuthenticationFlowsLookupFunction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.principal.PrincipalEvalPredicateFactoryRegistry;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class PopulateAuthenticationContext
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateAuthenticationContext.class);
    @Nonnull
    private Collection<AuthenticationFlowDescriptor> availableFlows = CollectionSupport.emptyList();
    @Nonnull
    private Function<ProfileRequestContext, Collection<AuthenticationFlowDescriptor>> potentialFlowsLookupStrategy = FunctionSupport.constant((Object)CollectionSupport.emptyList());
    @Nonnull
    private Function<ProfileRequestContext, Collection<String>> activeFlowsLookupStrategy = new AuthenticationFlowsLookupFunction();
    @Nullable
    private PrincipalEvalPredicateFactoryRegistry evalRegistry;
    @Nullable
    private Function<ProfileRequestContext, String> fixedEventLookupStrategy;

    public void setAvailableFlows(@Nonnull Collection<AuthenticationFlowDescriptor> flows) {
        this.checkSetterPreconditions();
        this.availableFlows = CollectionSupport.copyToList((Collection)((Collection)Constraint.isNotNull(flows, (String)"Flow collection cannot be null")));
    }

    public void setPotentialFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<AuthenticationFlowDescriptor>> strategy) {
        this.checkSetterPreconditions();
        this.potentialFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Potential flow lookup strategy cannot be null");
    }

    public void setActiveFlowsLookupStrategy(@Nonnull Function<ProfileRequestContext, Collection<String>> strategy) {
        this.checkSetterPreconditions();
        this.activeFlowsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Flow lookup strategy cannot be null");
    }

    @Nullable
    public PrincipalEvalPredicateFactoryRegistry getPrincipalPredicateFactoryEvalRegistry() {
        return this.evalRegistry;
    }

    public void setPrincipalEvalPredicateFactoryRegistry(@Nonnull PrincipalEvalPredicateFactoryRegistry registry) {
        this.checkSetterPreconditions();
        this.evalRegistry = (PrincipalEvalPredicateFactoryRegistry)Constraint.isNotNull((Object)registry, (String)"PrincipalEvalPredicateFactoryRegistry cannot be null");
    }

    public void setFixedEventLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.fixedEventLookupStrategy = strategy;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (this.evalRegistry != null) {
            authenticationContext.setPrincipalEvalPredicateFactoryRegistry(this.evalRegistry);
        }
        if (this.fixedEventLookupStrategy != null) {
            authenticationContext.setFixedEventLookupStrategy(this.fixedEventLookupStrategy);
        }
        if (this.availableFlows.isEmpty()) {
            this.log.warn("{} No authentication flows are available", (Object)this.getLogPrefix());
            return;
        }
        for (AuthenticationFlowDescriptor desc : this.availableFlows) {
            authenticationContext.getAvailableFlows().put(desc.ensureId(), desc);
        }
        Collection<String> activeFlows = this.activeFlowsLookupStrategy.apply(profileRequestContext);
        if (activeFlows != null && !activeFlows.isEmpty()) {
            for (AuthenticationFlowDescriptor desc : this.potentialFlowsLookupStrategy.apply(profileRequestContext)) {
                String flowId = desc.ensureId().substring(desc.ensureId().indexOf(47) + 1);
                if (activeFlows.contains(flowId)) {
                    if (authenticationContext.getAvailableFlows().containsKey(desc.ensureId()) && desc.test(profileRequestContext)) {
                        authenticationContext.getPotentialFlows().put(desc.ensureId(), desc);
                        continue;
                    }
                    this.log.debug("{} Filtered out authentication flow {}", (Object)this.getLogPrefix(), (Object)desc.ensureId());
                    continue;
                }
                this.log.debug("{} Filtered out authentication flow {} due to profile configuration", (Object)this.getLogPrefix(), (Object)desc.ensureId());
            }
        } else {
            for (AuthenticationFlowDescriptor desc : this.potentialFlowsLookupStrategy.apply(profileRequestContext)) {
                if (authenticationContext.getAvailableFlows().containsKey(desc.ensureId()) && desc.test(profileRequestContext)) {
                    authenticationContext.getPotentialFlows().put(desc.ensureId(), desc);
                    continue;
                }
                this.log.debug("{} Filtered out authentication flow {}", (Object)this.getLogPrefix(), (Object)desc.ensureId());
            }
        }
        if (authenticationContext.getPotentialFlows().isEmpty()) {
            this.log.warn("{} No authentication flows are active for this request", (Object)this.getLogPrefix());
        } else {
            this.log.debug("{} Installed {} potential authentication flows into AuthenticationContext", (Object)this.getLogPrefix(), (Object)authenticationContext.getPotentialFlows().size());
        }
    }
}

