/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.Collection;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.AbstractSubjectCanonicalizationAction;
import net.shibboleth.idp.authn.SubjectCanonicalizationFlowDescriptor;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class PopulateSubjectCanonicalizationContext
extends AbstractSubjectCanonicalizationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateSubjectCanonicalizationContext.class);
    @Nonnull
    private Collection<SubjectCanonicalizationFlowDescriptor> availableFlows = CollectionSupport.emptyList();

    PopulateSubjectCanonicalizationContext() {
    }

    public void setAvailableFlows(@Nonnull Collection<SubjectCanonicalizationFlowDescriptor> flows) {
        this.checkSetterPreconditions();
        this.availableFlows = CollectionSupport.copyToList((Collection)((Collection)Constraint.isNotNull(flows, (String)"Flow collection cannot be null")));
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        this.log.debug("{} Installing {} canonicalization flows into SubjectCanonicalizationContext", (Object)this.getLogPrefix(), (Object)this.availableFlows.size());
        for (SubjectCanonicalizationFlowDescriptor desc : this.availableFlows) {
            c14nContext.getPotentialFlows().put(desc.ensureId(), desc);
        }
    }
}

