/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context.impl;

import java.security.Principal;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.authn.principal.IdPAttributePrincipal;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;

public class IdPAttributePrincipalValuesFunction
extends AbstractInitializableComponent
implements Function<Principal, List<IdPAttributeValue>> {
    @NonnullAfterInit
    @NotEmpty
    private String attributeName;

    public void setAttributeName(@Nonnull @NotEmpty String attrName) {
        this.attributeName = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)attrName), (String)"Attribute Name cannot be null or empty");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.attributeName == null) {
            throw new ComponentInitializationException("Attribute name cannot be null or empty");
        }
    }

    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    public List<IdPAttributeValue> apply(@Nullable Principal principal) {
        IdPAttributePrincipal attributePrincipal;
        IdPAttribute attribute;
        if (principal instanceof IdPAttributePrincipal && this.attributeName.equals((attribute = (attributePrincipal = (IdPAttributePrincipal)principal).getAttribute()).getId())) {
            return attribute.getValues();
        }
        return null;
    }
}

