/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.context.impl;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.authn.context.navigate.SubjectCanonicalizationContextSubjectLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class SubjectDerivedAttributeValuesFunction
extends AbstractIdentifiableInitializableComponent
implements Function<ProfileRequestContext, List<IdPAttributeValue>> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SubjectDerivedAttributeValuesFunction.class);
    private boolean forCanonicalization;
    @Nonnull
    private Function<ProfileRequestContext, SubjectContext> scLookupStrategy = new ChildContextLookup(SubjectContext.class);
    @NonnullAfterInit
    private Function<Principal, List<IdPAttributeValue>> attributeValuesFunction;
    @Nullable
    private Function<ProfileRequestContext, Subject> subjectLookupStrategy;

    public void setForCanonicalization(boolean flag) {
        this.checkSetterPreconditions();
        this.forCanonicalization = flag;
    }

    public void setSubjectContextLookupStrategy(@Nonnull Function<ProfileRequestContext, SubjectContext> strategy) {
        this.checkSetterPreconditions();
        this.scLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SubjectContext lookup strategy cannot be null");
    }

    public void setAttributeValuesFunction(@Nonnull Function<Principal, List<IdPAttributeValue>> strategy) {
        this.checkSetterPreconditions();
        this.attributeValuesFunction = (Function)Constraint.isNotNull(strategy, (String)"Attribute value lookup strategy cannot be null");
    }

    public void setSubjectLookupStrategy(@Nullable Function<ProfileRequestContext, Subject> strategy) {
        this.checkSetterPreconditions();
        this.subjectLookupStrategy = strategy;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.attributeValuesFunction == null) {
            throw new ComponentInitializationException("Attribute value lookup strategy cannot be null");
        }
        if (this.forCanonicalization && this.subjectLookupStrategy == null) {
            this.log.debug("{} Marked for use during canonicalication, auto-installing Subject lookup strategy", (Object)this.getLogPrefix());
            this.subjectLookupStrategy = new SubjectCanonicalizationContextSubjectLookupFunction().compose((Function)new ChildContextLookup(SubjectCanonicalizationContext.class));
        }
    }

    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    public List<IdPAttributeValue> apply(@Nullable ProfileRequestContext prc) {
        List subjects = CollectionSupport.emptyList();
        if (this.subjectLookupStrategy != null) {
            Subject subject = this.subjectLookupStrategy.apply(prc);
            if (subject == null) {
                this.log.debug("{} No Subject returned from lookup, no attribute resolved", (Object)this.getLogPrefix());
                return null;
            }
            subjects = CollectionSupport.singletonList((Object)subject);
        } else {
            SubjectContext cs = this.scLookupStrategy.apply(prc);
            if (cs == null || cs.getSubjects().isEmpty()) {
                this.log.debug("{} No Subjects returned from SubjectContext lookup, no attribute resolved", (Object)this.getLogPrefix());
                return null;
            }
            subjects = cs.getSubjects();
        }
        ArrayList<IdPAttributeValue> results = new ArrayList<IdPAttributeValue>();
        for (Subject subject : subjects) {
            for (Principal principal : subject.getPrincipals()) {
                List<IdPAttributeValue> values = this.attributeValuesFunction.apply(principal);
                if (null == values || values.isEmpty()) continue;
                results.addAll(values);
            }
        }
        if (results.isEmpty()) {
            this.log.info("{} Generated no values, no attribute resolved", (Object)this.getLogPrefix());
            return null;
        }
        this.log.debug("{} Generated {} values", (Object)this.getLogPrefix(), (Object)results.size());
        this.log.trace("{} Values:", (Object)this.getLogPrefix(), results);
        return results;
    }

    private String getLogPrefix() {
        return "SubjectDerivedAttributeDefinition " + this.getId();
    }
}

