/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jasminb.jsonapi.models.errors.Error;
import com.github.jasminb.jsonapi.models.errors.Errors;
import com.google.common.base.Strings;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AccountLockoutManager;
import net.shibboleth.idp.authn.EnumeratableAccountLockoutManager;
import net.shibboleth.idp.authn.context.LockoutManagerContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.context.SpringRequestContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.springframework.webflow.execution.RequestContext;

public class DoLockoutManagerOperation
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String MANAGER_ID = "lockoutManagerId";
    @Nonnull
    @NotEmpty
    public static final String KEY = "key";
    @Nonnull
    @NotEmpty
    public static final String INEXACT = "inexact";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DoLockoutManagerOperation.class);
    @NonnullAfterInit
    private ObjectMapper objectMapper;
    @Nullable
    @NotEmpty
    private String managerId;
    @NonnullBeforeExec
    @NotEmpty
    private String key;
    private boolean inexact;
    @NonnullBeforeExec
    private AccountLockoutManager lockoutManager;

    public void setObjectMapper(@Nonnull ObjectMapper mapper) {
        this.checkSetterPreconditions();
        this.objectMapper = (ObjectMapper)Constraint.isNotNull((Object)mapper, (String)"ObjectMapper cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.objectMapper == null) {
            throw new ComponentInitializationException("ObjectMapper cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.getHttpServletRequest() == null || this.getHttpServletResponse() == null) {
            this.log.warn("{} No HttpServletRequest or HttpServletResponse available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        try {
            SpringRequestContext springRequestContext = (SpringRequestContext)profileRequestContext.getSubcontext(SpringRequestContext.class);
            if (springRequestContext == null) {
                this.log.warn("{} Spring request context not found in profile request context", (Object)this.getLogPrefix());
                this.sendError(500, "Internal Server Error", "System misconfiguration.");
                return false;
            }
            RequestContext requestContext = springRequestContext.getRequestContext();
            if (requestContext == null) {
                this.log.warn("{} Web Flow request context not found in Spring request context", (Object)this.getLogPrefix());
                this.sendError(500, "Internal Server Error", "System misconfiguration.");
                return false;
            }
            this.lockoutManager = this.setupLockoutManager(requestContext);
            if (this.lockoutManager == null) {
                this.sendError(404, "Invalid Lockout Manager", "Invalid lockout manager identifier in path.");
                return false;
            }
            this.key = (String)requestContext.getFlowScope().get(KEY);
            if (Strings.isNullOrEmpty((String)this.key)) {
                this.sendError(404, "Missing Account Key", "No account key specified.");
                return false;
            }
            String flag = (String)requestContext.getFlowScope().get(INEXACT);
            if (flag != null) {
                this.inexact = Boolean.valueOf(flag);
                if (this.inexact && !(this.lockoutManager instanceof EnumeratableAccountLockoutManager)) {
                    this.sendError(500, "Invalid Lockout Manager", "Lockout manager specified does not support inexact lookup.");
                    return false;
                }
            }
        }
        catch (IOException e) {
            this.log.error("{} I/O error issuing API response", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        block31: {
            ((LockoutManagerContext)profileRequestContext.ensureSubcontext(LockoutManagerContext.class)).setKey(this.key);
            try {
                HttpServletRequest request = this.getHttpServletRequest();
                HttpServletResponse response = this.getHttpServletResponse();
                assert (response != null && request != null);
                response.setContentType("application/json");
                response.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
                if ("GET".equals(request.getMethod())) {
                    try {
                        if (this.inexact) {
                            Iterable lockedKeys = ((EnumeratableAccountLockoutManager)this.getLockoutManager()).enumerate(profileRequestContext);
                            if (lockedKeys != null) {
                                response.setStatus(200);
                                JsonFactory jsonFactory = new JsonFactory();
                                try (JsonGenerator g = jsonFactory.createGenerator((OutputStream)response.getOutputStream()).useDefaultPrettyPrinter();){
                                    g.setCodec((ObjectCodec)this.objectMapper);
                                    g.writeStartObject();
                                    g.writeObjectFieldStart("data");
                                    g.writeStringField("id", this.managerId + "/" + this.key);
                                    g.writeStringField("type", "lockout-keys");
                                    g.writeArrayFieldStart("data");
                                    for (String k : lockedKeys) {
                                        g.writeString(k);
                                    }
                                    g.writeEndArray();
                                    g.writeEndObject();
                                    g.writeEndObject();
                                    break block31;
                                }
                            }
                            this.sendError(500, "Internal Server Error", "Lockout manager error.");
                            break block31;
                        }
                        boolean lockout = this.getLockoutManager().check(profileRequestContext);
                        response.setStatus(200);
                        JsonFactory jsonFactory = new JsonFactory();
                        try (JsonGenerator g = jsonFactory.createGenerator((OutputStream)response.getOutputStream()).useDefaultPrettyPrinter();){
                            g.setCodec((ObjectCodec)this.objectMapper);
                            g.writeStartObject();
                            g.writeObjectFieldStart("data");
                            g.writeStringField("type", "lockout-statuses");
                            g.writeStringField("id", this.managerId + "/" + this.key);
                            g.writeObjectFieldStart("attributes");
                            g.writeBooleanField("lockout", lockout);
                            g.writeEndObject();
                            g.writeEndObject();
                            break block31;
                        }
                    }
                    catch (IOException e) {
                        this.sendError(500, "Internal Server Error", "Lockout manager error.");
                    }
                    break block31;
                }
                if ("POST".equals(request.getMethod())) {
                    try {
                        if (!this.getLockoutManager().increment(profileRequestContext)) {
                            throw new IOException();
                        }
                        response.setStatus(204);
                    }
                    catch (IOException e) {
                        this.sendError(500, "Internal Server Error", "Lockout manager error.");
                    }
                } else if ("DELETE".equals(request.getMethod())) {
                    try {
                        if (!this.getLockoutManager().clear(profileRequestContext)) {
                            throw new IOException();
                        }
                        response.setStatus(204);
                    }
                    catch (IOException e) {
                        this.sendError(500, "Internal Server Error", "Lockout manager error.");
                    }
                } else {
                    this.log.warn("{} Invalid method: {}", (Object)this.getLogPrefix(), (Object)request.getMethod());
                    this.sendError(405, "Unknown Operation", "Only GET, POST, and DELETE are supported.");
                }
            }
            catch (IOException e) {
                this.log.error("{} I/O error responding to request", (Object)this.getLogPrefix(), (Object)e);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            }
        }
    }

    @Nullable
    private AccountLockoutManager setupLockoutManager(@Nonnull RequestContext requestContext) {
        this.managerId = (String)requestContext.getFlowScope().get(MANAGER_ID);
        if (this.managerId == null) {
            this.log.warn("{} No {} flow variable found in request", (Object)this.getLogPrefix(), (Object)MANAGER_ID);
            return null;
        }
        assert (this.managerId != null);
        return (AccountLockoutManager)this.getBean(requestContext, this.managerId, AccountLockoutManager.class);
    }

    @Nonnull
    private AccountLockoutManager getLockoutManager() {
        assert (this.isPreExecuteCalled());
        assert (this.lockoutManager != null);
        return this.lockoutManager;
    }

    private void sendError(int status, @Nonnull @NotEmpty String title, @Nonnull @NotEmpty String detail) throws IOException {
        HttpServletResponse response = this.getHttpServletResponse();
        assert (response != null);
        response.setContentType("application/json");
        response.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        response.setStatus(status);
        Error e = new Error();
        Errors errors = new Errors();
        errors.setErrors(CollectionSupport.singletonList((Object)e));
        e.setStatus(Integer.toString(status));
        e.setTitle(title);
        e.setDetail(detail);
        this.objectMapper.writer().withDefaultPrettyPrinter().writeValue((OutputStream)response.getOutputStream(), (Object)errors);
    }
}

