/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AbstractSubjectCanonicalizationAction;
import net.shibboleth.idp.authn.SubjectCanonicalizationException;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public class SimpleSubjectCanonicalization
extends AbstractSubjectCanonicalizationAction {
    @Nonnull
    private final ActivationCondition embeddedPredicate = new ActivationCondition();
    @Nullable
    private UsernamePrincipal usernamePrincipal;

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        if (this.embeddedPredicate.apply(profileRequestContext, c14nContext, true)) {
            Subject c14CtxSubject = c14nContext.getSubject();
            assert (c14CtxSubject != null);
            this.usernamePrincipal = c14CtxSubject.getPrincipals(UsernamePrincipal.class).iterator().next();
            return super.doPreExecute(profileRequestContext, c14nContext);
        }
        return false;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        assert (this.usernamePrincipal != null);
        c14nContext.setPrincipalName(this.applyTransforms(this.usernamePrincipal.getName()));
    }

    public static class ActivationCondition
    implements Predicate<ProfileRequestContext> {
        @Override
        public boolean test(@Nullable ProfileRequestContext input) {
            SubjectCanonicalizationContext c14nContext;
            if (input != null && (c14nContext = (SubjectCanonicalizationContext)input.getSubcontext(SubjectCanonicalizationContext.class)) != null) {
                return this.apply(input, c14nContext, false);
            }
            return false;
        }

        public boolean apply(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext, boolean duringAction) {
            Subject c14CtxSubject = c14nContext.getSubject();
            Set<UsernamePrincipal> usernames = c14CtxSubject != null ? c14CtxSubject.getPrincipals(UsernamePrincipal.class) : null;
            if (usernames == null || usernames.isEmpty()) {
                c14nContext.setException((Exception)new SubjectCanonicalizationException("No UsernamePrincipals were found"));
                if (duringAction) {
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
                }
                return false;
            }
            if (usernames.size() > 1) {
                c14nContext.setException((Exception)new SubjectCanonicalizationException("Multiple UsernamePrincipals were found"));
                if (duringAction) {
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
                }
                return false;
            }
            return true;
        }
    }
}

