/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.authn.impl.AbstractAuditingValidationAction;
import net.shibboleth.idp.authn.principal.UsernamePrincipal;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateFunctionResult
extends AbstractAuditingValidationAction {
    @Nonnull
    @NotEmpty
    private static final String DEFAULT_METRIC_NAME = "net.shibboleth.idp.authn.function";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateFunctionResult.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, ?> resultLookupStrategy;
    @Nullable
    private Object result;

    public ValidateFunctionResult() {
        this.setMetricName(DEFAULT_METRIC_NAME);
    }

    public void setResultLookupStrategy(@Nonnull Function<ProfileRequestContext, ?> strategy) {
        this.checkSetterPreconditions();
        this.resultLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Result lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resultLookupStrategy == null) {
            throw new ComponentInitializationException("Result lookup strategy cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        try {
            this.result = this.resultLookupStrategy.apply(profileRequestContext);
        }
        catch (Exception e) {
            this.log.info("{} Authentication by function failed with exception", (Object)this.getLogPrefix(), (Object)e);
            this.handleError(profileRequestContext, authenticationContext, e, "AuthenticationException");
            this.recordFailure(profileRequestContext);
            return;
        }
        if (this.result == null) {
            this.log.info("{} Authentication by function failed", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            this.recordFailure(profileRequestContext);
        } else if (this.result instanceof String) {
            this.log.info("{} Validated user via name '{}'", (Object)this.getLogPrefix(), this.result);
            this.recordSuccess(profileRequestContext);
            this.buildAuthenticationResult(profileRequestContext, authenticationContext);
        } else if (this.result instanceof Principal) {
            this.log.info("{} Validated user via Principal '{}'", (Object)this.getLogPrefix(), this.result);
            this.recordSuccess(profileRequestContext);
            this.buildAuthenticationResult(profileRequestContext, authenticationContext);
        } else if (this.result instanceof Subject) {
            this.log.info("{} Validated user via Subject", (Object)this.getLogPrefix());
            this.recordSuccess(profileRequestContext);
            this.buildAuthenticationResult(profileRequestContext, authenticationContext);
        } else {
            this.log.info("{} Authentication by function failed, result type was invalid", (Object)this.getLogPrefix());
            this.handleError(profileRequestContext, authenticationContext, "NoCredentials", "NoCredentials");
            this.recordFailure(profileRequestContext);
        }
    }

    @Nonnull
    protected Subject populateSubject(@Nonnull Subject subject) {
        Object res = this.result;
        assert (res != null);
        if (res instanceof String) {
            subject.getPrincipals().add((Principal)new UsernamePrincipal((String)res));
            return subject;
        }
        if (res instanceof Principal) {
            subject.getPrincipals().add((Principal)res);
            return subject;
        }
        if (res instanceof Subject) {
            ((Subject)res).getPrincipals().addAll(subject.getPrincipals());
            return (Subject)res;
        }
        throw new ConstraintViolationException("Result type was unexpected");
    }

    @Override
    @Nullable
    @Unmodifiable
    @NotLive
    protected Map<String, String> getAuditFields(@Nonnull ProfileRequestContext profileRequestContext) {
        String name;
        if (this.result instanceof String) {
            return CollectionSupport.singletonMap((Object)"u", (Object)((String)this.result));
        }
        if (this.result instanceof UsernamePrincipal) {
            return CollectionSupport.singletonMap((Object)"u", (Object)((UsernamePrincipal)this.result).getName());
        }
        if (this.result instanceof Subject && (name = this.getUsername((Subject)this.result)) != null) {
            return CollectionSupport.singletonMap((Object)"u", (Object)name);
        }
        return super.getAuditFields(profileRequestContext);
    }

    @Nullable
    private String getUsername(@Nonnull Subject subject) {
        Set<UsernamePrincipal> princs = subject.getPrincipals(UsernamePrincipal.class);
        if (princs != null && !princs.isEmpty()) {
            return princs.iterator().next().getName();
        }
        return null;
    }
}

