/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.impl;

import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import net.shibboleth.idp.authn.AbstractSubjectCanonicalizationAction;
import net.shibboleth.idp.authn.SubjectCanonicalizationException;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.cryptacular.x509.dn.Attribute;
import org.cryptacular.x509.dn.NameReader;
import org.cryptacular.x509.dn.RDN;
import org.cryptacular.x509.dn.RDNSequence;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.x509.X509Support;
import org.slf4j.Logger;

public class X500SubjectCanonicalization
extends AbstractSubjectCanonicalizationAction {
    private static final String CN_OID = "2.5.4.3";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(X500SubjectCanonicalization.class);
    @Nonnull
    private List<Integer> subjectAltNameTypes = CollectionSupport.emptyList();
    @Nonnull
    private List<String> objectIds = CollectionSupport.singletonList((Object)"2.5.4.3");
    @Nullable
    private X509Certificate certificate;
    @NonnullBeforeExec
    private X500Principal x500Principal;

    public void setSubjectAltNameTypes(@Nullable List<Integer> types) {
        this.checkSetterPreconditions();
        this.subjectAltNameTypes = types != null ? CollectionSupport.copyToList(types) : CollectionSupport.emptyList();
    }

    public void setObjectIds(@Nullable List<String> ids) {
        this.checkSetterPreconditions();
        this.objectIds = CollectionSupport.copyToList((Collection)StringSupport.normalizeStringCollection(ids));
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        Subject subject = c14nContext.getSubject();
        assert (subject != null);
        Set<X509Certificate> certificates = subject.getPublicCredentials(X509Certificate.class);
        if (certificates != null && certificates.size() == 1) {
            this.certificate = certificates.iterator().next();
            assert (this.certificate != null);
            this.x500Principal = this.certificate.getSubjectX500Principal();
        } else {
            Set<X500Principal> principals = subject.getPrincipals(X500Principal.class);
            if (principals != null && principals.size() == 1) {
                this.x500Principal = principals.iterator().next();
            }
        }
        if (this.x500Principal != null) {
            return super.doPreExecute(profileRequestContext, c14nContext);
        }
        c14nContext.setException((Exception)new SubjectCanonicalizationException("Neither a single X509Certificate nor X500Principal were found"));
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
        return false;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        X509Certificate localCopy = this.certificate;
        if (localCopy != null && !this.subjectAltNameTypes.isEmpty()) {
            this.log.debug("{} Searching for subjectAltName types ({})", (Object)this.getLogPrefix(), this.subjectAltNameTypes);
            List altnames = X509Support.getAltNames((X509Certificate)localCopy, (Integer[])this.subjectAltNameTypes.toArray(new Integer[0]));
            assert (altnames != null);
            for (Object altname : altnames) {
                if (!(altname instanceof String)) continue;
                this.log.debug("{} Extracted String-valued subjectAltName: {}", (Object)this.getLogPrefix(), altname);
                c14nContext.setPrincipalName(this.applyTransforms((String)altname));
                return;
            }
            this.log.debug("{} No suitable subjectAltName extension");
        }
        String x509PrincipalName = this.x500Principal.getName();
        this.log.debug("{} Searching for RDN to extract from DN: {}", (Object)this.getLogPrefix(), (Object)x509PrincipalName);
        try {
            RDNSequence dnAttrs = NameReader.readX500Principal((X500Principal)this.x500Principal);
            assert (dnAttrs != null);
            for (String oid : this.objectIds) {
                assert (oid != null);
                String rdn = this.findRDN(dnAttrs, oid);
                if (rdn == null) continue;
                this.log.debug("{} Extracted RDN with OID {}: {}", new Object[]{this.getLogPrefix(), oid, rdn});
                c14nContext.setPrincipalName(this.applyTransforms(rdn));
                return;
            }
            this.log.warn("{} Unable to extract a suitable RDN from DN: {}", (Object)this.getLogPrefix(), (Object)x509PrincipalName);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
        }
        catch (IllegalArgumentException e) {
            this.log.warn("{} Unable to parse subject DN: {}", new Object[]{this.getLogPrefix(), x509PrincipalName, e});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
            return;
        }
    }

    @Nullable
    protected String findRDN(@Nonnull RDNSequence sequence, @Nonnull @NotEmpty String oid) {
        for (RDN rdn : sequence.backward()) {
            for (Attribute attribute : rdn.getAttributes()) {
                if (!attribute.getType().getOid().equals(oid)) continue;
                return attribute.getValue();
            }
        }
        return null;
    }

    public static class ActivationCondition
    implements Predicate<ProfileRequestContext> {
        @Override
        public boolean test(@Nullable ProfileRequestContext input) {
            SubjectCanonicalizationContext c14nContext;
            if (input != null && (c14nContext = (SubjectCanonicalizationContext)input.getSubcontext(SubjectCanonicalizationContext.class)) != null) {
                return this.apply(input, c14nContext, false);
            }
            return false;
        }

        public boolean apply(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext, boolean duringAction) {
            Subject subject = c14nContext.getSubject();
            if (subject != null) {
                Set<X509Certificate> certificates = subject.getPublicCredentials(X509Certificate.class);
                if (certificates != null && certificates.size() == 1) {
                    return true;
                }
                Set<X500Principal> principals = subject.getPrincipals(X500Principal.class);
                if (principals != null && principals.size() == 1) {
                    return true;
                }
            }
            c14nContext.setException((Exception)new SubjectCanonicalizationException("Neither a single X509Certificate nor X500Principal were found"));
            if (duringAction) {
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
            }
            return false;
        }
    }
}

