/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn.revocation.impl;

import java.time.DateTimeException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiPredicate;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.DateTimeAttributeValue;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.AttributeResolver;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.profile.context.navigate.IssuerLookupFunction;
import net.shibboleth.profile.context.navigate.RelyingPartyIdLookupFunction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.service.ReloadableService;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.ScratchContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AttributeRevocationCondition
extends AbstractInitializableComponent
implements BiPredicate<ProfileRequestContext, AuthenticationResult> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeRevocationCondition.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> principalNameLookupStrategy;
    @Nullable
    private Function<ProfileRequestContext, String> issuerLookupStrategy = new IssuerLookupFunction();
    @Nullable
    private Function<ProfileRequestContext, String> recipientLookupStrategy = new RelyingPartyIdLookupFunction();
    @NonnullAfterInit
    private ReloadableService<AttributeResolver> attributeResolver;
    @NonnullAfterInit
    @NotEmpty
    private String attributeId;

    public void setPrincipalNameLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.principalNameLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Principal name lookup strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.issuerLookupStrategy = strategy;
    }

    public void setRecipientLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.recipientLookupStrategy = strategy;
    }

    public void setAttributeResolver(@Nonnull ReloadableService<AttributeResolver> service) {
        this.checkSetterPreconditions();
        this.attributeResolver = (ReloadableService)Constraint.isNotNull(service, (String)"ReloadableService<AttributeResolver> cannot be null");
    }

    public void setAttributeId(@Nonnull @NotEmpty String id) {
        this.checkSetterPreconditions();
        this.attributeId = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)id), (String)"Attribute ID cannot be null or empty");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.attributeResolver == null) {
            throw new ComponentInitializationException("ReloadableService<AttributeResolver> cannot be null");
        }
        if (this.principalNameLookupStrategy == null) {
            throw new ComponentInitializationException("Principal name lookup strategy cannot be null");
        }
        if (this.attributeId == null) {
            throw new ComponentInitializationException("Attribute ID to resolve cannot be null or empty");
        }
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext input, @Nullable AuthenticationResult input2) {
        this.checkComponentActive();
        if (input == null || input2 == null) {
            this.log.error("Called with null inputs");
            return true;
        }
        String principal = this.principalNameLookupStrategy.apply(input);
        if (principal == null) {
            this.log.error("Principal lookup strategy returned null value");
            return true;
        }
        this.log.debug("Checking revocation for principal name {} for {} result via attribute resolver", (Object)principal, (Object)input2.getAuthenticationFlowId());
        ScratchContext context = (ScratchContext)input.ensureSubcontext(ScratchContext.class);
        if (!context.getMap().containsKey(this.getClass())) {
            AttributeResolutionContext resolutionContext = this.buildResolutionContext(input, principal);
            assert (this.attributeResolver != null);
            resolutionContext.resolveAttributes(this.attributeResolver);
            ArrayList<Instant> records = new ArrayList<Instant>();
            if (resolutionContext.getResolvedIdPAttributes().containsKey(this.attributeId)) {
                for (IdPAttributeValue value : ((IdPAttribute)resolutionContext.getResolvedIdPAttributes().get(this.attributeId)).getValues()) {
                    if (value instanceof DateTimeAttributeValue) {
                        records.add(((DateTimeAttributeValue)value).getValue());
                        continue;
                    }
                    if (value instanceof StringAttributeValue) {
                        try {
                            records.add(Instant.ofEpochSecond(Long.valueOf(((StringAttributeValue)value).getValue())));
                        }
                        catch (NumberFormatException | DateTimeException e) {
                            this.log.error("Error parsing timestamp '{}' into epoch", (Object)((StringAttributeValue)value).getValue(), (Object)e);
                        }
                        continue;
                    }
                    this.log.warn("Ignoring non-string attribute value type: {}", (Object)value.getClass().getName());
                }
            } else {
                this.log.debug("Resolver did not return an IdPAttribute named {} for principal {}", (Object)this.attributeId, (Object)principal);
            }
            context.getMap().put(this.getClass(), records);
            resolutionContext.removeFromParent();
        }
        return this.isRevoked(principal, input2, (Collection)context.getMap().get(this.getClass()));
    }

    @Nonnull
    private AttributeResolutionContext buildResolutionContext(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull @NotEmpty String principal) {
        AttributeResolutionContext resolutionContext = new AttributeResolutionContext();
        resolutionContext.setPrincipal(principal).setResolutionLabel("authn/revocation");
        assert (this.attributeId != null);
        resolutionContext.setRequestedIdPAttributeNames((Collection)CollectionSupport.singletonList((Object)this.attributeId));
        if (this.recipientLookupStrategy != null) {
            resolutionContext.setAttributeRecipientID(this.recipientLookupStrategy.apply(profileRequestContext));
        }
        if (this.issuerLookupStrategy != null) {
            resolutionContext.setAttributeIssuerID(this.issuerLookupStrategy.apply(profileRequestContext));
        }
        profileRequestContext.addSubcontext((BaseContext)resolutionContext, true);
        return resolutionContext;
    }

    protected boolean isRevoked(@Nonnull @NotEmpty String principal, @Nonnull AuthenticationResult result, @Nonnull Collection<Instant> revocationRecords) {
        for (Instant i : revocationRecords) {
            if (!result.getAuthenticationInstant().isBefore(i)) continue;
            this.log.info("Authentication result {} for principal {} has been revoked", (Object)result.getAuthenticationFlowId(), (Object)principal);
            return true;
        }
        return false;
    }
}

