/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket;

import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.joda.time.Instant;

public class Ticket {
    @Nonnull
    private final String sessionId;
    @Nonnull
    private String id;
    @Nonnull
    private String service;
    @Nonnull
    private Instant expirationInstant;

    public Ticket(@Nonnull String id, @Nonnull String sessionId, @Nonnull String service, @Nonnull Instant expiration) {
        this.id = (String)Constraint.isNotNull((Object)id, (String)"Id cannot be null");
        this.sessionId = (String)Constraint.isNotNull((Object)sessionId, (String)"SessionId cannot be null");
        this.service = (String)Constraint.isNotNull((Object)service, (String)"Service cannot be null");
        this.expirationInstant = (Instant)Constraint.isNotNull((Object)expiration, (String)"Expiration cannot be null");
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getSessionId() {
        return this.sessionId;
    }

    @Nonnull
    public String getService() {
        return this.service;
    }

    @Nonnull
    public Instant getExpirationInstant() {
        return this.expirationInstant;
    }

    public boolean equals(Object o) {
        if (o == null || !o.getClass().equals(this.getClass())) {
            return false;
        }
        Ticket other = (Ticket)o;
        return other.id.equals(this.id);
    }

    public int hashCode() {
        return 23 + 31 * this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }
}

