/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.protocol;

import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class ServiceTicketRequest {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_POST = "POST";
    @Nonnull
    private final String serviceURL;
    private boolean renew;
    private boolean gateway;
    private boolean saml;
    private String method = "GET";

    public ServiceTicketRequest(@Nonnull String service) {
        this.serviceURL = (String)Constraint.isNotNull((Object)service, (String)"Service cannot be null");
    }

    @Nonnull
    public String getService() {
        return this.serviceURL;
    }

    public boolean isRenew() {
        return this.renew;
    }

    public void setRenew(boolean force) {
        this.renew = force;
    }

    public boolean isGateway() {
        return this.gateway;
    }

    public void setGateway(boolean doNotForce) {
        this.gateway = doNotForce;
    }

    public boolean isSAML() {
        return this.saml;
    }

    public void setSAML(boolean flag) {
        this.saml = flag;
    }

    @Nonnull
    public String getMethod() {
        return this.method;
    }

    public void setMethod(@Nonnull String m) {
        if (METHOD_GET.equalsIgnoreCase(m)) {
            this.method = METHOD_GET;
        } else if (METHOD_POST.equalsIgnoreCase(m)) {
            this.method = METHOD_POST;
        } else {
            throw new IllegalArgumentException("Unsupported method " + m);
        }
    }
}

