/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.service;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;

public class ServiceDefinition {
    @Nonnull
    private final String id;
    @Nullable
    private String group;
    private boolean authorizedToProxy;
    private boolean singleLogoutParticipant;

    public ServiceDefinition(@Nonnull @ParameterName(name="regex") @NotEmpty String regex) {
        this.id = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)regex), (String)"ID cannot be null or empty");
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getGroup() {
        return this.group;
    }

    public void setGroup(@NotEmpty String name) {
        this.group = StringSupport.trimOrNull((String)name);
    }

    public boolean isAuthorizedToProxy() {
        return this.authorizedToProxy;
    }

    public void setAuthorizedToProxy(boolean proxy) {
        this.authorizedToProxy = proxy;
    }

    public boolean isSingleLogoutParticipant() {
        return this.singleLogoutParticipant;
    }

    public void setSingleLogoutParticipant(boolean wantsSLO) {
        this.singleLogoutParticipant = wantsSLO;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        return o instanceof ServiceDefinition && this.id.equals(((ServiceDefinition)o).getId());
    }

    public int hashCode() {
        return 97 + this.id.hashCode();
    }

    public String toString() {
        return this.id;
    }
}

