/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.cas.ticket;

import java.time.Instant;
import javax.annotation.Nonnull;
import net.shibboleth.idp.cas.ticket.Ticket;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class ProxyTicket
extends Ticket {
    @Nonnull
    private final String pgTicketId;

    public ProxyTicket(@Nonnull String id, @Nonnull String service, @Nonnull Instant expiration, @Nonnull String pgtId) {
        super(id, service, expiration);
        this.pgTicketId = (String)Constraint.isNotNull((Object)pgtId, (String)"PgtId cannot be null");
    }

    @Nonnull
    public String getPgtId() {
        return this.pgTicketId;
    }

    @Override
    protected Ticket newInstance(String newId) {
        return new ProxyTicket(newId, this.getService(), this.getExpirationInstant(), this.pgTicketId);
    }
}

